/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.client.broker.BrokerClient;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.http.ClientSqlQuery;
import org.apache.druid.sql.http.ResultFormat;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class SegmentLoadStatusFetcher
implements AutoCloseable {
    private static final Logger log = new Logger(SegmentLoadStatusFetcher.class);
    private static final long SLEEP_DURATION_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    private static final long TIMEOUT_DURATION_MILLIS = TimeUnit.MINUTES.toMillis(10L);
    private static final String LOAD_QUERY = "SELECT COUNT(*) AS usedSegments,\nCOUNT(*) FILTER (WHERE is_published = 1 AND replication_factor > 0) AS precachedSegments,\nCOUNT(*) FILTER (WHERE is_published = 1 AND replication_factor = 0) AS onDemandSegments,\nCOUNT(*) FILTER (WHERE is_available = 0 AND is_published = 1 AND replication_factor != 0) AS pendingSegments,\nCOUNT(*) FILTER (WHERE replication_factor = -1) AS unknownSegments\nFROM sys.segments\nWHERE datasource = '%s' AND is_overshadowed = 0 AND (%s)";
    private final BrokerClient brokerClient;
    private final ObjectMapper objectMapper;
    private final AtomicReference<VersionLoadStatus> versionLoadStatusReference;
    private final String datasource;
    private final String versionsConditionString;
    private final int totalSegmentsGenerated;
    private final boolean doWait;
    private final AtomicReference<SegmentLoadWaiterStatus> status;
    private final ListeningExecutorService executorService;

    public SegmentLoadStatusFetcher(BrokerClient brokerClient, ObjectMapper objectMapper, String queryId, String datasource, Set<DataSegment> dataSegments, boolean doWait) {
        this.brokerClient = brokerClient;
        this.objectMapper = objectMapper;
        this.datasource = datasource;
        this.versionsConditionString = SegmentLoadStatusFetcher.createVersionCondition(dataSegments);
        this.totalSegmentsGenerated = dataSegments.size();
        this.versionLoadStatusReference = new AtomicReference<VersionLoadStatus>(new VersionLoadStatus(0, 0, 0, 0, this.totalSegmentsGenerated));
        this.status = new AtomicReference<SegmentLoadWaiterStatus>(new SegmentLoadWaiterStatus(State.INIT, null, 0L, this.totalSegmentsGenerated, 0, 0, 0, 0, this.totalSegmentsGenerated));
        this.doWait = doWait;
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)(StringUtils.encodeForFormat((String)queryId) + "-segment-load-waiter-%d")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSegmentsToLoad() {
        DateTime startTime = DateTimes.nowUtc();
        AtomicReference<Boolean> hasAnySegmentBeenLoaded = new AtomicReference<Boolean>(false);
        try {
            FutureUtils.getUnchecked((ListenableFuture)this.executorService.submit(() -> {
                long lastLogMillis = -TimeUnit.MINUTES.toMillis(1L);
                try {
                    while (!((Boolean)hasAnySegmentBeenLoaded.get()).booleanValue() || !this.versionLoadStatusReference.get().isLoadingComplete()) {
                        long runningMillis = new Interval((ReadableInstant)startTime, (ReadableInstant)DateTimes.nowUtc()).toDurationMillis();
                        if (runningMillis > TIMEOUT_DURATION_MILLIS) {
                            log.warn("Runtime[%d] exceeded timeout[%d] while waiting for segments to load. Exiting.", new Object[]{runningMillis, TIMEOUT_DURATION_MILLIS});
                            this.updateStatus(State.TIMED_OUT, startTime);
                            return;
                        }
                        if (runningMillis - lastLogMillis >= TimeUnit.MINUTES.toMillis(1L)) {
                            lastLogMillis = runningMillis;
                            log.info("Fetching segment load status for datasource[%s] from broker", new Object[]{this.datasource});
                        }
                        VersionLoadStatus loadStatus = this.fetchLoadStatusFromBroker();
                        this.versionLoadStatusReference.set(loadStatus);
                        hasAnySegmentBeenLoaded.set((Boolean)hasAnySegmentBeenLoaded.get() != false || loadStatus.getUsedSegments() > 0);
                        if (((Boolean)hasAnySegmentBeenLoaded.get()).booleanValue() && this.versionLoadStatusReference.get().isLoadingComplete()) continue;
                        this.updateStatus(State.WAITING, startTime);
                        this.waitIfNeeded(SLEEP_DURATION_MILLIS);
                    }
                }
                catch (Exception e) {
                    log.warn((Throwable)e, "Exception occurred while waiting for segments to load. Exiting.", new Object[0]);
                    this.updateStatus(State.FAILED, startTime);
                    return;
                }
                log.info("Segment loading completed for datasource[%s]", new Object[]{this.datasource});
                this.updateStatus(State.SUCCESS, startTime);
            }), (boolean)true);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Exception occurred while waiting for segments to load. Exiting.", new Object[0]);
            this.updateStatus(State.FAILED, startTime);
        }
        finally {
            this.executorService.shutdownNow();
        }
    }

    private void waitIfNeeded(long waitTimeMillis) throws Exception {
        if (this.doWait) {
            Thread.sleep(waitTimeMillis);
        }
    }

    private void updateStatus(State state, DateTime startTime) {
        long runningMillis = new Interval((ReadableInstant)startTime, (ReadableInstant)DateTimes.nowUtc()).toDurationMillis();
        VersionLoadStatus versionLoadStatus = this.versionLoadStatusReference.get();
        this.status.set(new SegmentLoadWaiterStatus(state, startTime, runningMillis, this.totalSegmentsGenerated, versionLoadStatus.getUsedSegments(), versionLoadStatus.getPrecachedSegments(), versionLoadStatus.getOnDemandSegments(), versionLoadStatus.getPendingSegments(), versionLoadStatus.getUnknownSegments()));
    }

    private VersionLoadStatus fetchLoadStatusFromBroker() throws Exception {
        ClientSqlQuery clientSqlQuery = new ClientSqlQuery(StringUtils.format((String)LOAD_QUERY, (Object[])new Object[]{this.datasource, this.versionsConditionString}), ResultFormat.OBJECTLINES.name(), false, false, false, null, null);
        String response = (String)FutureUtils.get((ListenableFuture)this.brokerClient.submitSqlQuery(clientSqlQuery), (boolean)true);
        if (response == null) {
            return new VersionLoadStatus(0, 0, 0, 0, this.totalSegmentsGenerated);
        }
        if (response.trim().isEmpty()) {
            return new VersionLoadStatus(0, 0, 0, 0, 0);
        }
        return (VersionLoadStatus)this.objectMapper.readValue(response, VersionLoadStatus.class);
    }

    private static String createVersionCondition(Set<DataSegment> dataSegments) {
        HashMap versionsVsPartitionNumberRangeMap = new HashMap();
        dataSegments.forEach(segment -> {
            String version = segment.getVersion();
            int partitionNum = segment.getId().getPartitionNum();
            versionsVsPartitionNumberRangeMap.computeIfPresent(version, (k, v) -> Pair.of((Object)(partitionNum < (Integer)v.lhs ? partitionNum : (Integer)v.lhs), (Object)(partitionNum > (Integer)v.rhs ? partitionNum : (Integer)v.rhs)));
            versionsVsPartitionNumberRangeMap.computeIfAbsent(version, k -> Pair.of((Object)partitionNum, (Object)partitionNum));
        });
        ArrayList<String> versionConditionList = new ArrayList<String>();
        for (Map.Entry stringPairEntry : versionsVsPartitionNumberRangeMap.entrySet()) {
            Pair pair = (Pair)stringPairEntry.getValue();
            versionConditionList.add(StringUtils.format((String)"(version = '%s' AND partition_num BETWEEN %s AND %s)", (Object[])new Object[]{stringPairEntry.getKey(), pair.lhs, pair.rhs}));
        }
        return String.join((CharSequence)" OR ", versionConditionList);
    }

    public SegmentLoadWaiterStatus status() {
        return this.status.get();
    }

    @Override
    public void close() {
        try {
            this.executorService.shutdownNow();
        }
        catch (Throwable suppressed) {
            log.warn(suppressed, "Error shutting down SegmentLoadStatusFetcher", new Object[0]);
        }
    }

    public static class VersionLoadStatus {
        private final int usedSegments;
        private final int precachedSegments;
        private final int onDemandSegments;
        private final int pendingSegments;
        private final int unknownSegments;

        @JsonCreator
        public VersionLoadStatus(@JsonProperty(value="usedSegments") int usedSegments, @JsonProperty(value="precachedSegments") int precachedSegments, @JsonProperty(value="onDemandSegments") int onDemandSegments, @JsonProperty(value="pendingSegments") int pendingSegments, @JsonProperty(value="unknownSegments") int unknownSegments) {
            this.usedSegments = usedSegments;
            this.precachedSegments = precachedSegments;
            this.onDemandSegments = onDemandSegments;
            this.pendingSegments = pendingSegments;
            this.unknownSegments = unknownSegments;
        }

        @JsonProperty
        public int getUsedSegments() {
            return this.usedSegments;
        }

        @JsonProperty
        public int getPrecachedSegments() {
            return this.precachedSegments;
        }

        @JsonProperty
        public int getOnDemandSegments() {
            return this.onDemandSegments;
        }

        @JsonProperty
        public int getPendingSegments() {
            return this.pendingSegments;
        }

        @JsonProperty
        public int getUnknownSegments() {
            return this.unknownSegments;
        }

        @JsonIgnore
        public boolean isLoadingComplete() {
            return this.pendingSegments == 0 && this.usedSegments == this.precachedSegments + this.onDemandSegments;
        }
    }

    public static class SegmentLoadWaiterStatus {
        private final State state;
        private final DateTime startTime;
        private final long duration;
        private final int totalSegments;
        private final int usedSegments;
        private final int precachedSegments;
        private final int onDemandSegments;
        private final int pendingSegments;
        private final int unknownSegments;

        @JsonCreator
        public SegmentLoadWaiterStatus(@JsonProperty(value="state") State state, @JsonProperty(value="startTime") @Nullable DateTime startTime, @JsonProperty(value="duration") long duration, @JsonProperty(value="totalSegments") int totalSegments, @JsonProperty(value="usedSegments") int usedSegments, @JsonProperty(value="precachedSegments") int precachedSegments, @JsonProperty(value="onDemandSegments") int onDemandSegments, @JsonProperty(value="pendingSegments") int pendingSegments, @JsonProperty(value="unknownSegments") int unknownSegments) {
            this.state = state;
            this.startTime = startTime;
            this.duration = duration;
            this.totalSegments = totalSegments;
            this.usedSegments = usedSegments;
            this.precachedSegments = precachedSegments;
            this.onDemandSegments = onDemandSegments;
            this.pendingSegments = pendingSegments;
            this.unknownSegments = unknownSegments;
        }

        @JsonProperty
        public State getState() {
            return this.state;
        }

        @Nullable
        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public DateTime getStartTime() {
            return this.startTime;
        }

        @JsonProperty
        public long getDuration() {
            return this.duration;
        }

        @JsonProperty
        public long getTotalSegments() {
            return this.totalSegments;
        }

        @JsonProperty
        public int getUsedSegments() {
            return this.usedSegments;
        }

        @JsonProperty
        public int getPrecachedSegments() {
            return this.precachedSegments;
        }

        @JsonProperty
        public int getOnDemandSegments() {
            return this.onDemandSegments;
        }

        @JsonProperty
        public int getPendingSegments() {
            return this.pendingSegments;
        }

        @JsonProperty
        public int getUnknownSegments() {
            return this.unknownSegments;
        }
    }

    public static enum State {
        INIT,
        WAITING,
        SUCCESS,
        FAILED,
        TIMED_OUT;


        public boolean isFinished() {
            return this == SUCCESS || this == FAILED || this == TIMED_OUT;
        }
    }
}

