/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec.std;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.frame.processor.BlockingQueueOutputChannelFactory;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.manager.ProcessorManager;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.msq.counters.CounterNames;
import org.apache.druid.msq.exec.ExecutionContext;
import org.apache.druid.msq.exec.FrameContext;
import org.apache.druid.msq.exec.std.ProcessorsAndChannels;
import org.apache.druid.msq.exec.std.ResultAndChannels;
import org.apache.druid.msq.exec.std.StandardShuffleOperations;
import org.apache.druid.msq.indexing.CountingOutputChannelFactory;
import org.apache.druid.msq.kernel.ShuffleSpec;
import org.apache.druid.msq.kernel.StageDefinition;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class StandardStageRunner<T, R> {
    private final ExecutionContext executionContext;
    private final int threadCount;
    private final FrameContext frameContext;
    private @MonotonicNonNull OutputChannelFactory workOutputChannelFactory;
    private @MonotonicNonNull ListenableFuture<R> workResultFuture;
    private @MonotonicNonNull ListenableFuture<ResultAndChannels<Object>> pipelineFuture;

    public StandardStageRunner(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.threadCount = executionContext.threadCount();
        this.frameContext = executionContext.frameContext();
    }

    public ListenableFuture<R> run(ProcessorsAndChannels<T, R> processors) {
        StageDefinition stageDefinition = this.executionContext.workOrder().getStageDefinition();
        this.makeAndRunWorkProcessors(processors);
        if (stageDefinition.doesShuffle()) {
            this.makeAndRunShuffleProcessors();
        }
        return FutureUtils.transformAsync((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{this.workResultFuture, FutureUtils.transformAsync(this.pipelineFuture, ResultAndChannels::resultFuture)}), ignored -> this.workResultFuture);
    }

    public OutputChannelFactory workOutputChannelFactory() {
        if (this.workOutputChannelFactory != null) {
            return this.workOutputChannelFactory;
        }
        StageDefinition stageDefinition = this.executionContext.workOrder().getStageDefinition();
        Object baseOutputChannelFactory = stageDefinition.doesShuffle() ? new BlockingQueueOutputChannelFactory(this.frameContext.memoryParameters().getFrameSize()) : this.executionContext.outputChannelFactory();
        this.workOutputChannelFactory = new CountingOutputChannelFactory((OutputChannelFactory)baseOutputChannelFactory, this.executionContext.counters().channel(CounterNames.outputChannel()));
        return this.workOutputChannelFactory;
    }

    private void makeAndRunWorkProcessors(ProcessorsAndChannels<T, R> processors) {
        ProcessorManager<T, R> processorManager = processors.getProcessorManager();
        int maxOutstandingProcessors = processors.getOutputChannels().getAllChannels().isEmpty() ? Math.max(1, this.threadCount) : Math.max(1, Math.min(this.threadCount, processors.getOutputChannels().getAllChannels().size()));
        this.workResultFuture = this.executionContext.executor().runAllFully(this.executionContext.counters().trackCpu(processorManager, "main"), maxOutstandingProcessors, this.executionContext.processingBouncer(), this.executionContext.cancellationId());
        ResultAndChannels<R> workResultAndChannels = new ResultAndChannels<R>(this.workResultFuture, processors.getOutputChannels());
        this.pipelineFuture = Futures.immediateFuture(workResultAndChannels);
    }

    private void makeAndRunShuffleProcessors() {
        ShuffleSpec shuffleSpec = this.executionContext.workOrder().getStageDefinition().getShuffleSpec();
        StandardShuffleOperations stageOperations = new StandardShuffleOperations(this.executionContext);
        this.pipelineFuture = stageOperations.gatherResultKeyStatisticsIfNeeded(this.pipelineFuture);
        CountingOutputChannelFactory stageOutputChannelFactory = new CountingOutputChannelFactory(this.executionContext.outputChannelFactory(), this.executionContext.counters().channel(CounterNames.shuffleChannel()));
        switch (shuffleSpec.kind()) {
            case MIX: {
                this.pipelineFuture = stageOperations.mix(this.pipelineFuture, stageOutputChannelFactory);
                break;
            }
            case HASH: {
                this.pipelineFuture = stageOperations.hashPartition(this.pipelineFuture, stageOutputChannelFactory);
                break;
            }
            case HASH_LOCAL_SORT: {
                Object hashOutputChannelFactory = shuffleSpec.partitionCount() == 1 ? new BlockingQueueOutputChannelFactory(this.frameContext.memoryParameters().getFrameSize()) : this.executionContext.makeIntermediateOutputChannelFactory("hash-parts");
                this.pipelineFuture = stageOperations.hashPartition(this.pipelineFuture, (OutputChannelFactory)hashOutputChannelFactory);
                this.pipelineFuture = stageOperations.localSort(this.pipelineFuture, stageOutputChannelFactory);
                break;
            }
            case GLOBAL_SORT: {
                this.pipelineFuture = stageOperations.globalSort(this.pipelineFuture, stageOutputChannelFactory);
                break;
            }
            default: {
                throw new UOE("Cannot handle shuffle kind [%s]", new Object[]{shuffleSpec.kind()});
            }
        }
    }
}

