/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.indexing.error.BaseMSQFault;
import org.apache.druid.query.JoinAlgorithm;

@JsonTypeName(value="BroadcastTablesTooLarge")
public class BroadcastTablesTooLargeFault
extends BaseMSQFault {
    static final String CODE = "BroadcastTablesTooLarge";
    private final long maxBroadcastTablesSize;
    @Nullable
    private final JoinAlgorithm configuredJoinAlgorithm;

    @JsonCreator
    public BroadcastTablesTooLargeFault(@JsonProperty(value="maxBroadcastTablesSize") long maxBroadcastTablesSize, @Nullable @JsonProperty(value="configuredJoinAlgorithm") JoinAlgorithm configuredJoinAlgorithm) {
        super(CODE, BroadcastTablesTooLargeFault.makeMessage(maxBroadcastTablesSize, configuredJoinAlgorithm));
        this.maxBroadcastTablesSize = maxBroadcastTablesSize;
        this.configuredJoinAlgorithm = configuredJoinAlgorithm;
    }

    @JsonProperty
    public long getMaxBroadcastTablesSize() {
        return this.maxBroadcastTablesSize;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public JoinAlgorithm getConfiguredJoinAlgorithm() {
        return this.configuredJoinAlgorithm;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BroadcastTablesTooLargeFault that = (BroadcastTablesTooLargeFault)o;
        return this.maxBroadcastTablesSize == that.maxBroadcastTablesSize && this.configuredJoinAlgorithm == that.configuredJoinAlgorithm;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxBroadcastTablesSize, this.configuredJoinAlgorithm);
    }

    private static String makeMessage(long maxBroadcastTablesSize, JoinAlgorithm configuredJoinAlgorithm) {
        if (configuredJoinAlgorithm == null || configuredJoinAlgorithm == JoinAlgorithm.BROADCAST) {
            return StringUtils.format((String)"Size of broadcast tables in JOIN exceeds reserved memory limit (memory reserved for broadcast tables = [%,d] bytes). Increase available memory, or set [%s: %s] in query context to use a shuffle-based join.", (Object[])new Object[]{maxBroadcastTablesSize, "sqlJoinAlgorithm", JoinAlgorithm.SORT_MERGE.toString()});
        }
        return StringUtils.format((String)"Size of broadcast tables in JOIN exceeds reserved memory limit (memory reserved for broadcast tables = [%,d] bytes). Try increasing available memory. This query is using broadcast JOIN even though [%s: %s] is set in query context, because the configured join algorithm does not support the join condition.", (Object[])new Object[]{maxBroadcastTablesSize, "sqlJoinAlgorithm", configuredJoinAlgorithm.toString()});
    }
}

