/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.inline;

import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.util.function.Consumer;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.ReadableInputs;
import org.apache.druid.msq.input.inline.InlineInputSlice;
import org.apache.druid.msq.input.table.RichSegmentDescriptor;
import org.apache.druid.msq.input.table.SegmentWithDescriptor;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.segment.CompleteSegment;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.timeline.SegmentId;

public class InlineInputSliceReader
implements InputSliceReader {
    public static final String SEGMENT_ID = "__inline";
    private static final RichSegmentDescriptor DUMMY_SEGMENT_DESCRIPTOR = new RichSegmentDescriptor(SegmentId.dummy((String)"__inline").toDescriptor(), null);
    private final SegmentWrangler segmentWrangler;

    public InlineInputSliceReader(SegmentWrangler segmentWrangler) {
        this.segmentWrangler = segmentWrangler;
    }

    @Override
    public int numReadableInputs(InputSlice slice) {
        return 1;
    }

    @Override
    public ReadableInputs attach(int inputNumber, InputSlice slice, CounterTracker counters, Consumer<Throwable> warningPublisher) {
        InlineDataSource dataSource = ((InlineInputSlice)slice).getDataSource();
        return ReadableInputs.segments(Iterables.transform((Iterable)this.segmentWrangler.getSegmentsForIntervals((DataSource)dataSource, (Iterable)Intervals.ONLY_ETERNITY), segment -> ReadableInput.segment(new SegmentWithDescriptor(() -> ResourceHolder.fromCloseable((Closeable)new CompleteSegment(null, segment)), DUMMY_SEGMENT_DESCRIPTOR))));
    }
}

