/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.querykit.QueryKit;
import org.apache.druid.msq.querykit.QueryKitSpec;
import org.apache.druid.msq.querykit.ShuffleSpecFactory;
import org.apache.druid.query.Query;

public class MultiQueryKit
implements QueryKit<Query<?>> {
    private final Map<Class<? extends Query>, QueryKit> toolKitMap;

    @Inject
    public MultiQueryKit(Map<Class<? extends Query>, QueryKit> toolKitMap) {
        this.toolKitMap = (Map)Preconditions.checkNotNull(toolKitMap, (Object)"toolKitMap");
    }

    @Override
    public QueryDefinition makeQueryDefinition(QueryKitSpec queryKitSpec, Query<?> query, ShuffleSpecFactory resultShuffleSpecFactory, int minStageNumber) {
        QueryKit specificToolKit = this.toolKitMap.get(query.getClass());
        if (specificToolKit != null) {
            return specificToolKit.makeQueryDefinition(queryKitSpec, query, resultShuffleSpecFactory, minStageNumber);
        }
        throw new ISE("Unsupported query class [%s]", new Object[]{query.getClass().getName()});
    }
}

