/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.client.indexing.TaskPayloadResponse;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.NotFound;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameCursor;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.counters.CounterSnapshots;
import org.apache.druid.msq.counters.CounterSnapshotsTree;
import org.apache.druid.msq.counters.QueryCounterSnapshot;
import org.apache.druid.msq.counters.SegmentGenerationProgressCounter;
import org.apache.druid.msq.exec.ResultsContext;
import org.apache.druid.msq.indexing.MSQControllerTask;
import org.apache.druid.msq.indexing.destination.DataSourceMSQDestination;
import org.apache.druid.msq.indexing.destination.DurableStorageMSQDestination;
import org.apache.druid.msq.indexing.destination.MSQDestination;
import org.apache.druid.msq.indexing.destination.TaskReportMSQDestination;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.indexing.error.MSQFault;
import org.apache.druid.msq.indexing.report.MSQStagesReport;
import org.apache.druid.msq.indexing.report.MSQTaskReport;
import org.apache.druid.msq.indexing.report.MSQTaskReportPayload;
import org.apache.druid.msq.sql.SqlStatementState;
import org.apache.druid.msq.sql.entity.ColumnNameAndTypes;
import org.apache.druid.msq.sql.entity.PageInformation;
import org.apache.druid.msq.sql.entity.SqlStatementResult;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.planner.ColumnMappings;
import org.apache.druid.sql.calcite.run.SqlResults;

public class SqlStatementResourceHelper {
    public static Optional<List<ColumnNameAndTypes>> getSignature(MSQControllerTask msqControllerTask) {
        if (!MSQControllerTask.isIngestion(msqControllerTask.getQuerySpec())) {
            ColumnMappings columnMappings = msqControllerTask.getQuerySpec().getColumnMappings();
            List<SqlTypeName> sqlTypeNames = msqControllerTask.getSqlTypeNames();
            if (sqlTypeNames == null || sqlTypeNames.size() != columnMappings.size()) {
                return Optional.empty();
            }
            List<ColumnType> nativeTypeNames = msqControllerTask.getNativeTypeNames();
            if (nativeTypeNames == null || nativeTypeNames.size() != columnMappings.size()) {
                return Optional.empty();
            }
            ArrayList<ColumnNameAndTypes> signature = new ArrayList<ColumnNameAndTypes>(columnMappings.size());
            int index = 0;
            for (String colName : columnMappings.getOutputColumnNames()) {
                signature.add(new ColumnNameAndTypes(colName, sqlTypeNames.get(index).getName(), nativeTypeNames.get(index).asTypeString()));
                ++index;
            }
            return Optional.of(signature);
        }
        return Optional.empty();
    }

    public static void isMSQPayload(TaskPayloadResponse taskPayloadResponse, String queryId) throws DruidException {
        if (taskPayloadResponse == null || taskPayloadResponse.getPayload() == null) {
            throw NotFound.exception((String)"Query[%s] not found", (Object[])new Object[]{queryId});
        }
        if (MSQControllerTask.class != taskPayloadResponse.getPayload().getClass()) {
            throw NotFound.exception((String)"Query[%s] not found", (Object[])new Object[]{queryId});
        }
    }

    public static SqlStatementState getSqlStatementState(TaskStatusPlus taskStatusPlus) {
        TaskState state = taskStatusPlus.getStatusCode();
        if (state == null) {
            return SqlStatementState.ACCEPTED;
        }
        switch (state) {
            case FAILED: {
                return SqlStatementState.FAILED;
            }
            case RUNNING: {
                if (TaskLocation.unknown().equals((Object)taskStatusPlus.getLocation())) {
                    return SqlStatementState.ACCEPTED;
                }
                return SqlStatementState.RUNNING;
            }
            case SUCCESS: {
                return SqlStatementState.SUCCESS;
            }
        }
        throw new ISE("Unrecognized state[%s] found.", new Object[]{state});
    }

    public static Optional<List<PageInformation>> populatePageList(MSQTaskReportPayload msqTaskReportPayload, MSQDestination msqDestination) {
        if (msqTaskReportPayload.getStages() == null || msqTaskReportPayload.getCounters() == null) {
            return Optional.empty();
        }
        MSQStagesReport.Stage finalStage = SqlStatementResourceHelper.getFinalStage(msqTaskReportPayload);
        CounterSnapshotsTree counterSnapshotsTree = msqTaskReportPayload.getCounters();
        Map<Integer, CounterSnapshots> workerCounters = counterSnapshotsTree.snapshotForStage(finalStage.getStageNumber());
        if (workerCounters == null || workerCounters.isEmpty()) {
            return Optional.empty();
        }
        if (msqDestination instanceof DataSourceMSQDestination) {
            long rows = 0L;
            for (CounterSnapshots counterSnapshots : workerCounters.values()) {
                QueryCounterSnapshot queryCounterSnapshot = counterSnapshots.getMap().getOrDefault("segmentGenerationProgress", null);
                if (!(queryCounterSnapshot instanceof SegmentGenerationProgressCounter.Snapshot)) continue;
                rows += ((SegmentGenerationProgressCounter.Snapshot)queryCounterSnapshot).getRowsPushed();
            }
            return Optional.of(ImmutableList.of((Object)new PageInformation(0L, rows, null)));
        }
        if (msqDestination instanceof TaskReportMSQDestination) {
            long rows = 0L;
            long size = 0L;
            for (CounterSnapshots counterSnapshots : workerCounters.values()) {
                QueryCounterSnapshot queryCounterSnapshot = counterSnapshots.getMap().getOrDefault("output", null);
                if (!(queryCounterSnapshot instanceof ChannelCounters.Snapshot)) continue;
                rows += Arrays.stream(((ChannelCounters.Snapshot)queryCounterSnapshot).getRows()).sum();
                size += Arrays.stream(((ChannelCounters.Snapshot)queryCounterSnapshot).getBytes()).sum();
            }
            return Optional.of(ImmutableList.of((Object)new PageInformation(0L, rows, size)));
        }
        if (msqDestination instanceof DurableStorageMSQDestination) {
            return SqlStatementResourceHelper.populatePagesForDurableStorageDestination(finalStage, workerCounters);
        }
        return Optional.empty();
    }

    private static Optional<List<PageInformation>> populatePagesForDurableStorageDestination(MSQStagesReport.Stage finalStage, Map<Integer, CounterSnapshots> workerCounters) {
        int totalPartitions = finalStage.getPartitionCount();
        int totalWorkerCount = finalStage.getWorkerCount();
        if (totalPartitions == -1) {
            throw DruidException.defensive((String)"Expected partition count to be set for stage[%d]", (Object[])new Object[]{finalStage});
        }
        if (totalWorkerCount == -1) {
            throw DruidException.defensive((String)"Expected worker count to be set for stage[%d]", (Object[])new Object[]{finalStage});
        }
        ArrayList<PageInformation> pages = new ArrayList<PageInformation>();
        for (int partitionNumber = 0; partitionNumber < totalPartitions; ++partitionNumber) {
            for (int workerNumber = 0; workerNumber < totalWorkerCount; ++workerNumber) {
                QueryCounterSnapshot channelCounters;
                CounterSnapshots workerCounter = workerCounters.get(workerNumber);
                if (workerCounter == null || workerCounter.getMap() == null || !((channelCounters = workerCounter.getMap().get("output")) instanceof ChannelCounters.Snapshot)) continue;
                long rows = 0L;
                long size = 0L;
                if (((ChannelCounters.Snapshot)channelCounters).getRows().length > partitionNumber) {
                    rows += ((ChannelCounters.Snapshot)channelCounters).getRows()[partitionNumber];
                    size += ((ChannelCounters.Snapshot)channelCounters).getBytes()[partitionNumber];
                }
                if (rows == 0L) continue;
                pages.add(new PageInformation(pages.size(), rows, size, workerNumber, partitionNumber));
            }
        }
        return Optional.of(pages);
    }

    public static Optional<SqlStatementResult> getExceptionPayload(String queryId, TaskStatusResponse taskResponse, TaskStatusPlus statusPlus, SqlStatementState sqlStatementState, MSQTaskReportPayload msqTaskReportPayload, ObjectMapper jsonMapper, boolean detail) {
        MSQFault fault;
        MSQErrorReport exceptionDetails = SqlStatementResourceHelper.getQueryExceptionDetails(msqTaskReportPayload);
        MSQFault mSQFault = fault = exceptionDetails == null ? null : exceptionDetails.getFault();
        if (exceptionDetails == null || fault == null) {
            return Optional.of(new SqlStatementResult(queryId, sqlStatementState, taskResponse.getStatus().getCreatedTime(), null, taskResponse.getStatus().getDuration(), null, DruidException.forPersona((DruidException.Persona)DruidException.Persona.DEVELOPER).ofCategory(DruidException.Category.UNCATEGORIZED).build("%s", new Object[]{taskResponse.getStatus().getErrorMsg()}).toErrorResponse(), detail ? SqlStatementResourceHelper.getQueryStagesReport(msqTaskReportPayload) : null, detail ? SqlStatementResourceHelper.getQueryCounters(msqTaskReportPayload) : null, detail ? SqlStatementResourceHelper.getQueryWarningDetails(msqTaskReportPayload) : null));
        }
        final String errorMessage = fault.getErrorMessage() == null ? statusPlus.getErrorMsg() : fault.getErrorMessage();
        String errorCode = fault.getErrorCode() == null ? "unknown" : fault.getErrorCode();
        final Map<String, String> exceptionContext = SqlStatementResourceHelper.buildExceptionContext(fault, jsonMapper);
        return Optional.of(new SqlStatementResult(queryId, sqlStatementState, taskResponse.getStatus().getCreatedTime(), null, taskResponse.getStatus().getDuration(), null, DruidException.fromFailure((DruidException.Failure)new DruidException.Failure(errorCode){

            protected DruidException makeException(DruidException.DruidExceptionBuilder bob) {
                DruidException ex = bob.forPersona(DruidException.Persona.USER).ofCategory(DruidException.Category.UNCATEGORIZED).build(errorMessage, new Object[0]);
                ex.withContext(exceptionContext);
                return ex;
            }
        }).toErrorResponse(), detail ? SqlStatementResourceHelper.getQueryStagesReport(msqTaskReportPayload) : null, detail ? SqlStatementResourceHelper.getQueryCounters(msqTaskReportPayload) : null, detail ? SqlStatementResourceHelper.getQueryWarningDetails(msqTaskReportPayload) : null));
    }

    public static Sequence<Object[]> getResultSequence(Frame resultsFrame, FrameReader resultFrameReader, ColumnMappings resultColumnMappings, ResultsContext resultsContext, ObjectMapper jsonMapper) {
        FrameCursor cursor = FrameProcessors.makeCursor((Frame)resultsFrame, (FrameReader)resultFrameReader);
        ColumnSelectorFactory columnSelectorFactory = cursor.getColumnSelectorFactory();
        List selectors = resultColumnMappings.getMappings().stream().map(mapping -> columnSelectorFactory.makeColumnValueSelector(mapping.getQueryColumn())).collect(Collectors.toList());
        Iterable retVal = () -> SqlStatementResourceHelper.lambda$getResultSequence$1((Cursor)cursor, resultColumnMappings, selectors, resultsContext, jsonMapper);
        return Sequences.simple(retVal);
    }

    @Nullable
    public static MSQStagesReport.Stage getFinalStage(@Nullable MSQTaskReportPayload msqTaskReportPayload) {
        if (msqTaskReportPayload == null || msqTaskReportPayload.getStages().getStages() == null) {
            return null;
        }
        int finalStageNumber = msqTaskReportPayload.getStages().getStages().size() - 1;
        for (MSQStagesReport.Stage stage : msqTaskReportPayload.getStages().getStages()) {
            if (stage.getStageNumber() != finalStageNumber) continue;
            return stage;
        }
        return null;
    }

    @Nullable
    private static MSQErrorReport getQueryExceptionDetails(@Nullable MSQTaskReportPayload payload) {
        return payload == null ? null : payload.getStatus().getErrorReport();
    }

    @Nullable
    public static List<MSQErrorReport> getQueryWarningDetails(@Nullable MSQTaskReportPayload payload) {
        return payload == null ? null : new ArrayList<MSQErrorReport>(payload.getStatus().getWarningReports());
    }

    @Nullable
    public static MSQStagesReport getQueryStagesReport(@Nullable MSQTaskReportPayload payload) {
        return payload == null ? null : payload.getStages();
    }

    @Nullable
    public static CounterSnapshotsTree getQueryCounters(@Nullable MSQTaskReportPayload payload) {
        return payload == null ? null : payload.getCounters();
    }

    @Nullable
    public static MSQTaskReportPayload getPayload(TaskReport.ReportMap reportMap) {
        if (reportMap == null) {
            return null;
        }
        Optional report = reportMap.findReport("multiStageQuery");
        return report.map(MSQTaskReport::getPayload).orElse(null);
    }

    private static Map<String, String> buildExceptionContext(MSQFault fault, ObjectMapper mapper) {
        try {
            HashMap<String, Object> msqFaultAsMap = new HashMap<String, Object>((Map)mapper.readValue(mapper.writeValueAsBytes((Object)fault), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT));
            msqFaultAsMap.remove("errorCode");
            msqFaultAsMap.remove("errorMessage");
            HashMap<String, String> exceptionContext = new HashMap<String, String>();
            msqFaultAsMap.forEach((key, value) -> exceptionContext.put((String)key, String.valueOf(value)));
            return exceptionContext;
        }
        catch (Exception e) {
            throw DruidException.defensive((String)"Could not read MSQFault[%s] as a map: [%s]", (Object[])new Object[]{fault, e.getMessage()});
        }
    }

    private static /* synthetic */ Iterator lambda$getResultSequence$1(final Cursor cursor, final ColumnMappings resultColumnMappings, final List selectors, final ResultsContext resultsContext, final ObjectMapper jsonMapper) {
        return new Iterator<Object[]>(){

            @Override
            public boolean hasNext() {
                return !cursor.isDone();
            }

            @Override
            public Object[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] row = new Object[resultColumnMappings.size()];
                for (int i = 0; i < row.length; ++i) {
                    Object value = ((ColumnValueSelector)selectors.get(i)).getObject();
                    row[i] = resultsContext.getSqlTypeNames() == null || resultsContext.getSqlResultsContext() == null ? value : SqlResults.coerce((ObjectMapper)jsonMapper, (SqlResults.Context)resultsContext.getSqlResultsContext(), (Object)value, (SqlTypeName)resultsContext.getSqlTypeNames().get(i), (String)resultColumnMappings.getOutputColumnName(i));
                }
                cursor.advance();
                return row;
            }
        };
    }
}

