/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.hdfs;

import com.google.inject.Inject;
import java.io.IOException;
import org.apache.druid.guice.Hdfs;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

@ManageLifecycle
public class HdfsStorageAvailabilityChecker {
    private final Configuration hadoopConf;

    @Inject
    public HdfsStorageAvailabilityChecker(@Hdfs Configuration hadoopConf) {
        this.hadoopConf = hadoopConf;
    }

    @LifecycleStart
    public void checkHdfsAvailability() {
        try {
            boolean disableCache = this.hadoopConf.getBoolean("fs.hdfs.impl.disable.cache", false);
            if (!disableCache) {
                FileSystem fs = FileSystem.get((Configuration)this.hadoopConf);
                fs.exists(new Path("/"));
            }
        }
        catch (IOException ex) {
            throw new ISE((Throwable)ex, "Failed to access hdfs.", new Object[0]);
        }
    }

    @LifecycleStop
    public void stop() {
    }
}

