/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.batch.options;

import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobUrlParts;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.RehydratePriority;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;

public class BlobBatchSetBlobAccessTierOptions {
    private static final ClientLogger LOGGER = new ClientLogger(BlobBatchSetBlobAccessTierOptions.class);
    private final BlobUrlParts blobUrlParts;
    private final AccessTier tier;
    private RehydratePriority priority;
    private String leaseId;
    private String tagsConditions;

    public BlobBatchSetBlobAccessTierOptions(String blobUrl, AccessTier tier) {
        StorageImplUtils.assertNotNull((String)"blobUrl", (Object)blobUrl);
        StorageImplUtils.assertNotNull((String)"tier", (Object)tier);
        this.blobUrlParts = BlobUrlParts.parse((String)blobUrl);
        this.tier = tier;
    }

    public BlobBatchSetBlobAccessTierOptions(String containerName, String blobName, AccessTier tier) {
        StorageImplUtils.assertNotNull((String)"containerName", (Object)containerName);
        StorageImplUtils.assertNotNull((String)"blobName", (Object)blobName);
        StorageImplUtils.assertNotNull((String)"tier", (Object)tier);
        this.blobUrlParts = BlobUrlParts.parse((String)"https://account.blob.core.windows.net").setContainerName(containerName).setBlobName(blobName);
        this.tier = tier;
    }

    public String getBlobUrl() {
        return this.blobUrlParts.toUrl().toString();
    }

    public String getBlobContainerName() {
        return this.blobUrlParts.getBlobContainerName();
    }

    public String getBlobName() {
        return this.blobUrlParts.getBlobName();
    }

    public String getBlobIdentifier() {
        String basePath = this.blobUrlParts.getBlobContainerName() + "/" + this.blobUrlParts.getBlobName();
        String snapshot = this.blobUrlParts.getSnapshot();
        String versionId = this.blobUrlParts.getVersionId();
        if (snapshot != null && versionId != null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("'snapshot' and 'versionId' cannot be used at the same time."));
        }
        if (snapshot != null) {
            basePath = Utility.appendQueryParameter((String)basePath, (String)"snapshot", (String)snapshot);
        }
        if (versionId != null) {
            basePath = Utility.appendQueryParameter((String)basePath, (String)"versionid", (String)versionId);
        }
        return basePath;
    }

    public String getVersionId() {
        return this.blobUrlParts.getVersionId();
    }

    public BlobBatchSetBlobAccessTierOptions setVersionId(String versionId) {
        this.blobUrlParts.setVersionId(versionId);
        return this;
    }

    public String getSnapshot() {
        return this.blobUrlParts.getSnapshot();
    }

    public BlobBatchSetBlobAccessTierOptions setSnapshot(String snapshot) {
        this.blobUrlParts.setSnapshot(snapshot);
        return this;
    }

    public AccessTier getTier() {
        return this.tier;
    }

    public RehydratePriority getPriority() {
        return this.priority;
    }

    public BlobBatchSetBlobAccessTierOptions setPriority(RehydratePriority priority) {
        this.priority = priority;
        return this;
    }

    public String getLeaseId() {
        return this.leaseId;
    }

    public BlobBatchSetBlobAccessTierOptions setLeaseId(String leaseId) {
        this.leaseId = leaseId;
        return this;
    }

    public String getTagsConditions() {
        return this.tagsConditions;
    }

    public BlobBatchSetBlobAccessTierOptions setTagsConditions(String tagsConditions) {
        this.tagsConditions = tagsConditions;
        return this;
    }
}

