/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.controller.event;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public class RGStreamCutRecord {
    public static final RGStreamCutRecordSerializer SERIALIZER = new RGStreamCutRecordSerializer();
    final ImmutableMap<Long, Long> streamCut;

    public RGStreamCutRecord(@NonNull ImmutableMap<Long, Long> streamCut) {
        if (streamCut == null) {
            throw new NullPointerException("streamCut is marked non-null but is null");
        }
        this.streamCut = streamCut;
    }

    public Map<Long, Long> getStreamCut() {
        return Collections.unmodifiableMap(this.streamCut);
    }

    public static RGStreamCutRecord fromBytes(byte[] data) {
        return (RGStreamCutRecord)SERIALIZER.deserialize(data);
    }

    public byte[] toBytes() {
        return SERIALIZER.serialize(this).getCopy();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static RGStreamCutRecordBuilder builder() {
        return new RGStreamCutRecordBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RGStreamCutRecord)) {
            return false;
        }
        RGStreamCutRecord other = (RGStreamCutRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Long, Long> this$streamCut = this.getStreamCut();
        Map<Long, Long> other$streamCut = other.getStreamCut();
        return !(this$streamCut == null ? other$streamCut != null : !((Object)this$streamCut).equals(other$streamCut));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RGStreamCutRecord;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Long, Long> $streamCut = this.getStreamCut();
        result = result * 59 + ($streamCut == null ? 43 : ((Object)$streamCut).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "RGStreamCutRecord(streamCut=" + this.getStreamCut() + ")";
    }

    public static class RGStreamCutRecordSerializer
    extends VersionedSerializer.WithBuilder<RGStreamCutRecord, RGStreamCutRecordBuilder> {
        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, RGStreamCutRecordBuilder streamCutRecordBuilder) throws IOException {
            ImmutableMap.Builder streamCutBuilder = ImmutableMap.builder();
            revisionDataInput.readMap(DataInput::readLong, DataInput::readLong, streamCutBuilder);
            streamCutRecordBuilder.streamCut((ImmutableMap<Long, Long>)streamCutBuilder.build());
        }

        private void write00(RGStreamCutRecord streamCutRecord, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeMap(streamCutRecord.getStreamCut(), DataOutput::writeLong, DataOutput::writeLong);
        }

        protected RGStreamCutRecordBuilder newBuilder() {
            return RGStreamCutRecord.builder();
        }
    }

    private static class RGStreamCutRecordBuilder
    implements ObjectBuilder<RGStreamCutRecord> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private ImmutableMap<Long, Long> streamCut;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        RGStreamCutRecordBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RGStreamCutRecordBuilder streamCut(@NonNull ImmutableMap<Long, Long> streamCut) {
            if (streamCut == null) {
                throw new NullPointerException("streamCut is marked non-null but is null");
            }
            this.streamCut = streamCut;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RGStreamCutRecord build() {
            return new RGStreamCutRecord(this.streamCut);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "RGStreamCutRecord.RGStreamCutRecordBuilder(streamCut=" + this.streamCut + ")";
        }
    }
}

