/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import lombok.Generated;

public class EventMeshThreadFactory
implements ThreadFactory {
    private final String threadNamePrefix;
    private final AtomicInteger threadIndex;
    private final boolean daemon;
    private final Integer priority;

    public EventMeshThreadFactory(String threadNamePrefix, AtomicInteger threadIndex, boolean daemon, Integer priority) {
        this.threadNamePrefix = threadNamePrefix;
        this.threadIndex = threadIndex;
        this.daemon = daemon;
        this.priority = priority;
    }

    public EventMeshThreadFactory(String threadNamePrefix, AtomicInteger threadIndex, boolean daemon) {
        this(threadNamePrefix, threadIndex, daemon, null);
    }

    public EventMeshThreadFactory(String threadNamePrefix, boolean daemon, Integer priority) {
        this(threadNamePrefix, new AtomicInteger(0), daemon, priority);
    }

    public EventMeshThreadFactory(String threadNamePrefix, boolean daemon) {
        this(threadNamePrefix, new AtomicInteger(0), daemon);
    }

    public EventMeshThreadFactory(String threadNamePrefix) {
        this(threadNamePrefix, new AtomicInteger(0), false);
    }

    @Override
    public Thread newThread(@Nonnull Runnable runnable) {
        StringBuilder threadName = new StringBuilder(this.threadNamePrefix);
        if (this.threadIndex != null) {
            threadName.append("-").append(this.threadIndex.incrementAndGet());
        }
        Thread thread = new Thread(runnable, threadName.toString());
        thread.setDaemon(this.daemon);
        if (this.priority != null) {
            thread.setPriority(this.priority);
        }
        return thread;
    }

    @Generated
    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }
}

