/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v1;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.EventMeshTcp2Client;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/clientManage/rejectAllClient")
public class RejectAllClientHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RejectAllClientHandler.class);
    private final transient EventMeshTCPServer eventMeshTCPServer;

    public RejectAllClientHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void handle(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
        ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
        ArrayList<InetSocketAddress> successRemoteAddrs = new ArrayList<InetSocketAddress>();
        try {
            log.info("rejectAllClient in admin====================");
            if (!sessionMap.isEmpty()) {
                for (Map.Entry<InetSocketAddress, Session> entry : sessionMap.entrySet()) {
                    InetSocketAddress addr = EventMeshTcp2Client.serverGoodby2Client(this.eventMeshTCPServer.getTcpThreadPoolGroup(), entry.getValue(), clientSessionGroupMapping);
                    if (addr == null) continue;
                    successRemoteAddrs.add(addr);
                }
            }
        }
        catch (Exception e) {
            log.error("clientManage rejectAllClient fail", (Throwable)e);
            this.writeText(ctx, String.format("rejectAllClient fail! sessionMap size {%d}, had reject {%s}, errorMsg : %s", sessionMap.size(), NetUtils.addressToString(successRemoteAddrs), e.getMessage()));
            return;
        }
        this.writeText(ctx, String.format("rejectAllClient success! sessionMap size {%d}, had reject {%s}", sessionMap.size(), NetUtils.addressToString(successRemoteAddrs)));
    }
}

