/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v1;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.group.ClientSessionGroupMapping;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/clientManage/showClient")
public class ShowClientHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShowClientHandler.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public ShowClientHandler(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void handle(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        StringBuilder result = new StringBuilder();
        String newLine = System.getProperty("line.separator");
        log.info("showAllClient=================");
        ClientSessionGroupMapping clientSessionGroupMapping = this.eventMeshTCPServer.getClientSessionGroupMapping();
        HashMap<String, AtomicInteger> statMap = new HashMap<String, AtomicInteger>();
        ConcurrentHashMap<InetSocketAddress, Session> sessionMap = clientSessionGroupMapping.getSessionMap();
        if (!sessionMap.isEmpty()) {
            for (Session session : sessionMap.values()) {
                String key = session.getClient().getSubsystem();
                if (!statMap.containsKey(key)) {
                    statMap.put(key, new AtomicInteger(1));
                    continue;
                }
                ((AtomicInteger)statMap.get(key)).incrementAndGet();
            }
            for (Map.Entry entry : statMap.entrySet()) {
                result.append(String.format("System=%s | ClientNum=%d", entry.getKey(), ((AtomicInteger)entry.getValue()).intValue())).append(newLine);
            }
        }
        this.writeText(ctx, result.toString());
    }
}

