/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import lombok.Generated;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.runtime.boot.EventMeshBootstrap;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.boot.EventMeshServer;
import org.apache.eventmesh.runtime.configuration.EventMeshGrpcConfiguration;

public class EventMeshGrpcBootstrap
implements EventMeshBootstrap {
    private final EventMeshGrpcConfiguration eventMeshGrpcConfiguration;
    private EventMeshGrpcServer eventMeshGrpcServer;
    private final EventMeshServer eventMeshServer;

    public EventMeshGrpcBootstrap(EventMeshServer eventMeshServer) {
        this.eventMeshServer = eventMeshServer;
        ConfigService configService = ConfigService.getInstance();
        this.eventMeshGrpcConfiguration = (EventMeshGrpcConfiguration)((Object)configService.buildConfigInstance(EventMeshGrpcConfiguration.class));
        ConfigurationContextUtil.putIfAbsent((String)"GRPC", (CommonConfiguration)this.eventMeshGrpcConfiguration);
    }

    @Override
    public void init() throws Exception {
        if (this.eventMeshGrpcConfiguration != null) {
            this.eventMeshGrpcServer = new EventMeshGrpcServer(this.eventMeshServer, this.eventMeshGrpcConfiguration);
            this.eventMeshGrpcServer.init();
        }
    }

    @Override
    public void start() throws Exception {
        if (this.eventMeshGrpcConfiguration != null) {
            this.eventMeshGrpcServer.start();
        }
    }

    @Override
    public void shutdown() throws Exception {
        if (this.eventMeshGrpcConfiguration != null) {
            this.eventMeshGrpcServer.shutdown();
        }
    }

    @Generated
    public EventMeshGrpcServer getEventMeshGrpcServer() {
        return this.eventMeshGrpcServer;
    }
}

