/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.boot;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.runtime.boot.ThreadPoolGroup;
import org.apache.eventmesh.runtime.configuration.EventMeshTCPConfiguration;

public class TCPThreadPoolGroup
implements ThreadPoolGroup {
    private final EventMeshTCPConfiguration eventMeshTCPConfiguration;
    private ScheduledExecutorService scheduler;
    private ThreadPoolExecutor taskHandleExecutorService;
    private ThreadPoolExecutor sendExecutorService;
    private ThreadPoolExecutor ackExecutorService;
    private ThreadPoolExecutor replyExecutorService;
    private ThreadPoolExecutor broadcastMsgDownstreamExecutorService;

    public TCPThreadPoolGroup(EventMeshTCPConfiguration eventMeshTCPConfiguration) {
        this.eventMeshTCPConfiguration = eventMeshTCPConfiguration;
    }

    @Override
    public void initThreadPool() {
        this.scheduler = ThreadPoolFactory.createScheduledExecutor((int)this.eventMeshTCPConfiguration.getEventMeshTcpGlobalScheduler(), (ThreadFactory)new EventMeshThreadFactory("eventMesh-tcp-scheduler", true));
        this.taskHandleExecutorService = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshTCPConfiguration.getEventMeshTcpTaskHandleExecutorPoolSize(), (int)this.eventMeshTCPConfiguration.getEventMeshTcpTaskHandleExecutorPoolSize(), new LinkedBlockingQueue(this.eventMeshTCPConfiguration.getEventMeshTcpTaskHandleExecutorQueueSize()), (ThreadFactory)new EventMeshThreadFactory("eventMesh-tcp-task-handle", true));
        this.sendExecutorService = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshTCPConfiguration.getEventMeshTcpMsgSendExecutorPoolSize(), (int)this.eventMeshTCPConfiguration.getEventMeshTcpMsgSendExecutorPoolSize(), new LinkedBlockingQueue(this.eventMeshTCPConfiguration.getEventMeshTcpMsgSendExecutorQueueSize()), (ThreadFactory)new EventMeshThreadFactory("eventMesh-tcp-msg-send", true));
        this.replyExecutorService = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshTCPConfiguration.getEventMeshTcpMsgReplyExecutorPoolSize(), (int)this.eventMeshTCPConfiguration.getEventMeshTcpMsgReplyExecutorPoolSize(), new LinkedBlockingQueue(this.eventMeshTCPConfiguration.getEventMeshTcpMsgReplyExecutorQueueSize()), (ThreadFactory)new EventMeshThreadFactory("eventMesh-tcp-msg-reply", true));
        this.ackExecutorService = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshTCPConfiguration.getEventMeshTcpMsgAckExecutorPoolSize(), (int)this.eventMeshTCPConfiguration.getEventMeshTcpMsgAckExecutorPoolSize(), new LinkedBlockingQueue(this.eventMeshTCPConfiguration.getEventMeshTcpMsgAckExecutorQueueSize()), (ThreadFactory)new EventMeshThreadFactory("eventMesh-tcp-msg-ack", true));
        this.broadcastMsgDownstreamExecutorService = ThreadPoolFactory.createThreadPoolExecutor((int)this.eventMeshTCPConfiguration.getEventMeshTcpMsgDownStreamExecutorPoolSize(), (int)this.eventMeshTCPConfiguration.getEventMeshTcpMsgDownStreamExecutorPoolSize(), new LinkedBlockingQueue(10000), (ThreadFactory)new EventMeshThreadFactory("eventMesh-tcp-msg-downstream", true));
    }

    @Override
    public void shutdownThreadPool() {
        this.scheduler.shutdown();
        this.taskHandleExecutorService.shutdown();
        this.sendExecutorService.shutdown();
        this.replyExecutorService.shutdown();
        this.ackExecutorService.shutdown();
        this.broadcastMsgDownstreamExecutorService.shutdown();
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public ThreadPoolExecutor getTaskHandleExecutorService() {
        return this.taskHandleExecutorService;
    }

    public ThreadPoolExecutor getBroadcastMsgDownstreamExecutorService() {
        return this.broadcastMsgDownstreamExecutorService;
    }

    public ThreadPoolExecutor getSendExecutorService() {
        return this.sendExecutorService;
    }

    public ThreadPoolExecutor getAckExecutorService() {
        return this.ackExecutorService;
    }

    public ThreadPoolExecutor getReplyExecutorService() {
        return this.replyExecutorService;
    }
}

