/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.http.push;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPClientPool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HTTPClientPool.class);
    private final transient List<CloseableHttpClient> clients = Collections.synchronizedList(new ArrayList());
    private final int core;
    private static final int DEFAULT_MAX_TOTAL = 200;
    private static final int DEFAULT_IDLETIME_SECONDS = 30;
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int SOCKET_TIMEOUT = 5000;
    private transient PoolingHttpClientConnectionManager connectionManager;

    public HTTPClientPool(int core) {
        this.core = core <= 0 ? 1 : core;
    }

    public CloseableHttpClient getClient() {
        if (CollectionUtils.size(this.clients) < this.core) {
            CloseableHttpClient client = this.getHttpClient(200, 30, null);
            this.clients.add(client);
            return client;
        }
        return this.clients.get(ThreadLocalRandom.current().nextInt(this.core, 2 * this.core) % this.core);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        List<CloseableHttpClient> list = this.clients;
        synchronized (list) {
            Iterator<CloseableHttpClient> itr = this.clients.iterator();
            while (itr.hasNext()) {
                CloseableHttpClient client = itr.next();
                try {
                    itr.remove();
                }
                finally {
                    if (client == null) continue;
                    client.close();
                }
            }
        }
        if (this.connectionManager == null) {
            this.connectionManager.close();
        }
    }

    public CloseableHttpClient getHttpClient(int maxTotal, int idleTimeInSeconds, SSLContext sslContext) {
        SSLContext innerSSLContext = sslContext;
        try {
            innerSSLContext = innerSSLContext == null ? SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TheTrustStrategy()).build() : innerSSLContext;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            log.error("Get sslContext error", (Throwable)e);
            return HttpClients.createDefault();
        }
        if (this.connectionManager == null) {
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(innerSSLContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
            this.connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            this.connectionManager.setDefaultMaxPerRoute(maxTotal);
            this.connectionManager.setMaxTotal(maxTotal);
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        return HttpClients.custom().setDefaultRequestConfig(config).setConnectionManager((HttpClientConnectionManager)this.connectionManager).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy()).evictIdleConnections((long)idleTimeInSeconds, TimeUnit.SECONDS).setConnectionReuseStrategy((ConnectionReuseStrategy)new DefaultConnectionReuseStrategy()).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler()).build();
    }

    private static class TheTrustStrategy
    implements TrustStrategy {
        private TheTrustStrategy() {
        }

        public boolean isTrusted(X509Certificate[] chain, String authType) {
            return true;
        }
    }
}

