/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.core.protocol.tcp.client.processor;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.common.protocol.SubscriptionItem;
import org.apache.eventmesh.common.protocol.tcp.Command;
import org.apache.eventmesh.common.protocol.tcp.Header;
import org.apache.eventmesh.common.protocol.tcp.OPStatus;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.runtime.acl.Acl;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.processor.TcpProcessor;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.session.Session;
import org.apache.eventmesh.runtime.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnSubscribeProcessor
implements TcpProcessor {
    private static final Logger MESSAGE_LOGGER = LoggerFactory.getLogger((String)"message");
    private EventMeshTCPServer eventMeshTCPServer;
    private final Acl acl;

    public UnSubscribeProcessor(EventMeshTCPServer eventMeshTCPServer) {
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.acl = eventMeshTCPServer.getAcl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Package pkg, ChannelHandlerContext ctx, long startTime) {
        Session session = this.eventMeshTCPServer.getClientSessionGroupMapping().getSession(ctx);
        long taskExecuteTime = System.currentTimeMillis();
        Package msg = new Package();
        try {
            Session session2 = session;
            synchronized (session2) {
                ConcurrentHashMap<String, SubscriptionItem> subscribeTopics = session.getSessionContext().getSubscribeTopics();
                if (MapUtils.isNotEmpty(subscribeTopics)) {
                    ArrayList<SubscriptionItem> topics = new ArrayList<SubscriptionItem>(subscribeTopics.values());
                    session.unsubscribe(topics);
                    MESSAGE_LOGGER.info("UnSubscriberTask succeed|user={}|topics={}", (Object)session.getClient(), topics);
                }
            }
            msg.setHeader(new Header(Command.UNSUBSCRIBE_RESPONSE, OPStatus.SUCCESS.getCode().intValue(), OPStatus.SUCCESS.getDesc(), pkg.getHeader().getSeq()));
        }
        catch (Exception e) {
            MESSAGE_LOGGER.error("UnSubscribeTask failed|user={}|errMsg={}", (Object)session.getClient(), (Object)e);
            msg.setHeader(new Header(Command.UNSUBSCRIBE_RESPONSE, OPStatus.FAIL.getCode().intValue(), "exception while unSubscribing", pkg.getHeader().getSeq()));
        }
        finally {
            Utils.writeAndFlush(msg, startTime, taskExecuteTime, session.getContext(), session);
        }
    }
}

