/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.eventmesh.metrics.api.MetricsRegistry;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.runtime.metrics.MetricsManager;
import org.apache.eventmesh.runtime.metrics.MetricsUtils;

public class EventMeshMetricsManager {
    private List<MetricsRegistry> metricsRegistries = new ArrayList<MetricsRegistry>(64);
    private List<Metric> metrics = new ArrayList<Metric>(64);
    private List<MetricsManager> metricsManagers = new ArrayList<MetricsManager>(32);

    public EventMeshMetricsManager(List<MetricsRegistry> metricsRegistries) {
        if (Objects.nonNull(metricsRegistries)) {
            this.metricsRegistries.addAll(metricsRegistries);
        }
    }

    public EventMeshMetricsManager() {
    }

    public List<MetricsRegistry> getMetricsRegistries() {
        return this.metricsRegistries;
    }

    public void addMetricsRegistries(List<MetricsRegistry> metricsRegistries) {
        if (Objects.nonNull(metricsRegistries)) {
            this.metricsRegistries.addAll(metricsRegistries);
        }
    }

    public void addMetrics(List<Metric> metrics) {
        if (Objects.nonNull(metrics)) {
            this.metrics.addAll(metrics);
        }
    }

    public void addMetricManager(MetricsManager metricsManager) {
        this.metricsManagers.add(metricsManager);
    }

    public void addMetric(Metric metric) {
        if (Objects.nonNull(metric)) {
            this.metrics.add(metric);
        }
    }

    public void init() {
        MetricsUtils.registerMetrics(this.metricsRegistries);
        this.metricsRegistries.stream().forEach(metricsRegistry -> metricsRegistry.register(this.metrics));
    }

    public void start() {
        this.metricsManagers.stream().forEach(MetricsManager::start);
        this.metricsRegistries.stream().forEach(MetricsRegistry::start);
    }

    public void shutdown() {
        this.metricsRegistries.stream().forEach(MetricsRegistry::showdown);
        this.metricsManagers.stream().forEach(MetricsManager::shutdown);
    }
}

