/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.eventmesh.metrics.api.MetricsRegistry;
import org.apache.eventmesh.runtime.metrics.GeneralMetrics;

public final class MetricsUtils {
    private static Attributes EMPTY_ATTRIBUTES = Attributes.builder().build();

    public static void registerMetrics(List<MetricsRegistry> metricsRegistries) {
        metricsRegistries.forEach(metricsRegistry -> metricsRegistry.register(GeneralMetrics.getMetrics()));
    }

    public static void incrementClientToEventMeshMsgNum(Map<String, String> attributes) {
        GeneralMetrics.client2eventMeshMsgNum.getInstrument().add(1L, MetricsUtils.buildAttributes(attributes));
    }

    public static void incrementClientToEventMeshMsgNum(Map<String, String> attributes, int count) {
        GeneralMetrics.client2eventMeshMsgNum.getInstrument().add((long)count, MetricsUtils.buildAttributes(attributes));
    }

    public static void incrementEventMeshToMQMsgNum(Map<String, String> attributes) {
        GeneralMetrics.eventMesh2mqMsgNum.getInstrument().add(1L, MetricsUtils.buildAttributes(attributes));
    }

    public static void incrementMQToEventMeshMsgNum(Map<String, String> attributes) {
        GeneralMetrics.mq2eventMeshMsgNum.getInstrument().add(1L, MetricsUtils.buildAttributes(attributes));
    }

    public static void incrementEventMeshToClientMsgNum(Map<String, String> attributes) {
        GeneralMetrics.eventMesh2clientMsgNum.getInstrument().add(1L, MetricsUtils.buildAttributes(attributes));
    }

    public static Attributes buildAttributes(Map<String, String> attributes) {
        if (MapUtils.isEmpty(attributes)) {
            return EMPTY_ATTRIBUTES;
        }
        AttributesBuilder attributesBuilder = Attributes.builder();
        attributes.forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return attributesBuilder.build();
    }

    @Generated
    private MetricsUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

