/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics.grpc;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.enums.ProtocolType;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.metrics.api.MetricsRegistry;
import org.apache.eventmesh.metrics.api.model.Metric;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.metrics.MetricsManager;
import org.apache.eventmesh.runtime.metrics.MetricsUtils;
import org.apache.eventmesh.runtime.metrics.grpc.GrpcMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshGrpcMetricsManager
implements MetricsManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventMeshGrpcMetricsManager.class);
    private static final long DELAY_MILLS = 60000L;
    private static final long SCHEDULE_PERIOD_MILLS = 60000L;
    private static final int SCHEDULE_THREAD_SIZE = 1;
    private static final String THREAD_NAME_PREFIX = "eventMesh-grpc-monitor-scheduler";
    private final Map<String, String> labelMap = new HashMap<String, String>();
    private final EventMeshGrpcServer eventMeshGrpcServer;
    private final List<MetricsRegistry> metricsRegistries;
    private final ScheduledExecutorService scheduler;
    private ScheduledFuture<?> scheduleTask;
    private final GrpcMetrics grpcMetrics;

    public EventMeshGrpcMetricsManager(EventMeshGrpcServer eventMeshGrpcServer, List<MetricsRegistry> metricsRegistries) {
        this.eventMeshGrpcServer = (EventMeshGrpcServer)Preconditions.checkNotNull((Object)eventMeshGrpcServer);
        this.metricsRegistries = (List)Preconditions.checkNotNull(metricsRegistries);
        this.grpcMetrics = new GrpcMetrics(eventMeshGrpcServer, this.labelMap);
        this.scheduler = ThreadPoolFactory.createScheduledExecutor((int)1, (ThreadFactory)new EventMeshThreadFactory(THREAD_NAME_PREFIX, true));
        this.init();
    }

    private void init() {
        String eventMeshServerIp = this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().getEventMeshServerIp();
        int eventMeshTcpServerPort = this.eventMeshGrpcServer.getEventMeshGrpcConfiguration().getGrpcServerPort();
        this.labelMap.put("rpc.system", "grpc");
        this.labelMap.put("rpc.service", this.eventMeshGrpcServer.getClass().getName());
        this.labelMap.put("net.peer.name", Optional.ofNullable(eventMeshServerIp).orElse(IPUtils.getLocalAddress()));
        this.labelMap.put("net.peer.port", Integer.toString(eventMeshTcpServerPort));
    }

    @Override
    public void start() {
        this.scheduleTask = this.scheduler.scheduleAtFixedRate(() -> {
            this.grpcMetrics.refreshTpsMetrics(60000L);
            this.grpcMetrics.clearAllMessageCounter();
            this.grpcMetrics.setRetrySize(0L);
            this.grpcMetrics.setSubscribeTopicNum(this.eventMeshGrpcServer.getConsumerManager().getAllConsumerTopic().size());
        }, 60000L, 60000L, TimeUnit.MILLISECONDS);
    }

    public void recordReceiveMsgFromClient(String clientAddress) {
        this.grpcMetrics.getClient2EventMeshMsgNum().incrementAndGet();
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        attributes.put("client.protocol.type", ProtocolType.GRPC.name());
        attributes.put("client.address", Optional.ofNullable(clientAddress).orElse("unkown"));
        MetricsUtils.incrementClientToEventMeshMsgNum(attributes);
    }

    public void recordReceiveMsgFromClient(int count, String clientAddress) {
        this.grpcMetrics.getClient2EventMeshMsgNum().addAndGet(count);
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        attributes.put("client.protocol.type", ProtocolType.GRPC.name());
        attributes.put("client.address", Optional.ofNullable(clientAddress).orElse("unkown"));
        MetricsUtils.incrementClientToEventMeshMsgNum(attributes, count);
    }

    public void recordSendMsgToQueue() {
        this.grpcMetrics.getEventMesh2MqMsgNum().incrementAndGet();
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        MetricsUtils.incrementEventMeshToMQMsgNum(attributes);
    }

    public void recordReceiveMsgFromQueue() {
        this.grpcMetrics.getMq2EventMeshMsgNum().incrementAndGet();
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        MetricsUtils.incrementMQToEventMeshMsgNum(attributes);
    }

    public void recordSendMsgToClient(String clientAddress) {
        this.grpcMetrics.getEventMesh2ClientMsgNum().incrementAndGet();
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        attributes.put("client.protocol.type", ProtocolType.TCP.name());
        attributes.put("client.address", Optional.ofNullable(clientAddress).orElse("unkown"));
        MetricsUtils.incrementEventMeshToClientMsgNum(attributes);
    }

    public void recordGrpcPublishHandleCost(long costTime, String clientAddress) {
        HashMap<String, String> attributes = new HashMap<String, String>(this.labelMap);
        attributes.put("client.protocol.type", ProtocolType.TCP.name());
        attributes.put("client.address", Optional.ofNullable(clientAddress).orElse("unkown"));
        this.grpcMetrics.recordGrpcPublishHandleCost(costTime, MetricsUtils.buildAttributes(attributes));
    }

    @Override
    public void shutdown() {
        this.scheduleTask.cancel(true);
        this.scheduler.shutdown();
    }

    @Override
    public List<Metric> getMetrics() {
        return new ArrayList<Metric>(this.grpcMetrics.getMetrics());
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }
}

