/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.meta.consul.service;

import com.ecwid.consul.transport.TLSConfig;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.ConsulRawClient;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.health.HealthServicesRequest;
import com.ecwid.consul.v1.health.model.HealthService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.exception.MetaException;
import org.apache.eventmesh.api.meta.MetaService;
import org.apache.eventmesh.api.meta.MetaServiceListener;
import org.apache.eventmesh.api.meta.dto.EventMeshDataInfo;
import org.apache.eventmesh.api.meta.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.meta.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.meta.consul.config.ConsulTLSConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulMetaService
implements MetaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConsulMetaService.class);
    public static final String IP_PORT_SEPARATOR = ":";
    private final AtomicBoolean initStatus = new AtomicBoolean(false);
    private final AtomicBoolean startStatus = new AtomicBoolean(false);
    private String consulHost;
    private String consulPort;
    private ConsulClient consulClient;
    private String token;
    private ConsulTLSConfig tlsConfig;

    public void init() throws MetaException {
        if (this.initStatus.compareAndSet(false, true)) {
            ConsulTLSConfig tlsConfig;
            for (String key : ConfigurationContextUtil.KEYS) {
                CommonConfiguration commonConfiguration = ConfigurationContextUtil.get((String)key);
                if (commonConfiguration == null) continue;
                String metaStorageAddr = commonConfiguration.getMetaStorageAddr();
                if (StringUtils.isBlank((CharSequence)metaStorageAddr)) {
                    throw new MetaException("namesrvAddr cannot be null");
                }
                String[] addr = metaStorageAddr.split(IP_PORT_SEPARATOR);
                if (addr.length != 2) {
                    throw new MetaException("Illegal namesrvAddr");
                }
                this.consulHost = addr[0];
                this.consulPort = addr[1];
                break;
            }
            this.tlsConfig = tlsConfig = (ConsulTLSConfig)ConfigService.getInstance().buildConfigInstance(ConsulTLSConfig.class);
        }
    }

    public void start() throws MetaException {
        if (!this.startStatus.compareAndSet(false, true)) {
            return;
        }
        ConsulRawClient.Builder builder = ConsulRawClient.Builder.builder();
        builder.setHost(this.consulHost);
        builder.setPort(Integer.parseInt(this.consulPort));
        if (this.tlsConfig != null && Objects.nonNull(this.tlsConfig.getKeyStoreInstanceType()) && !StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.tlsConfig.getCertificatePassword(), this.tlsConfig.getCertificatePath(), this.tlsConfig.getKeyStorePassword(), this.tlsConfig.getKeyStorePath()})) {
            builder.setTlsConfig(this.convertToTlsConfig(this.tlsConfig));
        }
        this.consulClient = new ConsulClient(builder.build());
    }

    private TLSConfig convertToTlsConfig(ConsulTLSConfig tlsConfig) {
        return new TLSConfig(tlsConfig.getKeyStoreInstanceType(), tlsConfig.getCertificatePath(), tlsConfig.getCertificatePassword(), tlsConfig.getKeyStorePath(), tlsConfig.getKeyStorePassword());
    }

    public void shutdown() throws MetaException {
        if (!this.initStatus.compareAndSet(true, false)) {
            return;
        }
        if (!this.startStatus.compareAndSet(true, false)) {
            return;
        }
        this.consulClient = null;
    }

    public boolean register(EventMeshRegisterInfo eventMeshRegisterInfo) throws MetaException {
        try {
            String[] ipPort = eventMeshRegisterInfo.getEndPoint().split(IP_PORT_SEPARATOR);
            if (ipPort == null || ipPort.length < 2) {
                return false;
            }
            NewService service = new NewService();
            service.setPort(Integer.valueOf(Integer.parseInt(ipPort[1])));
            service.setAddress(ipPort[0]);
            service.setName(eventMeshRegisterInfo.getEventMeshName());
            service.setId(eventMeshRegisterInfo.getEventMeshClusterName() + "-" + eventMeshRegisterInfo.getEventMeshName());
            this.consulClient.agentServiceRegister(service, this.token);
        }
        catch (Exception e) {
            throw new MetaException(e.getMessage());
        }
        log.info("EventMesh successfully registered to consul");
        return true;
    }

    public boolean unRegister(EventMeshUnRegisterInfo eventMeshUnRegisterInfo) throws MetaException {
        try {
            this.consulClient.agentServiceDeregister(eventMeshUnRegisterInfo.getEventMeshClusterName() + "-" + eventMeshUnRegisterInfo.getEventMeshName(), this.token);
        }
        catch (Exception e) {
            throw new MetaException(e.getMessage());
        }
        log.info("EventMesh successfully unregistered to consul");
        return true;
    }

    public void getMetaDataWithListener(MetaServiceListener metaServiceListener, String key) {
    }

    public List<EventMeshDataInfo> findEventMeshInfoByCluster(String clusterName) throws MetaException {
        HealthServicesRequest request = HealthServicesRequest.newBuilder().setPassing(true).setToken(this.token).build();
        List healthServices = (List)this.consulClient.getHealthServices(clusterName, request).getValue();
        ArrayList<EventMeshDataInfo> eventMeshDataInfos = new ArrayList<EventMeshDataInfo>();
        healthServices.forEach(healthService -> {
            HealthService.Service service = healthService.getService();
            String[] split = service.getId().split("-");
            eventMeshDataInfos.add(new EventMeshDataInfo(split[0], split[1], service.getAddress() + IP_PORT_SEPARATOR + service.getPort(), 0L, service.getMeta()));
        });
        return eventMeshDataInfos;
    }

    public List<EventMeshDataInfo> findAllEventMeshInfo() throws MetaException {
        Map agentServices = (Map)this.consulClient.getAgentServices().getValue();
        ArrayList<EventMeshDataInfo> eventMeshDataInfos = new ArrayList<EventMeshDataInfo>();
        agentServices.forEach((k, v) -> {
            String[] split = v.getId().split("-");
            eventMeshDataInfos.add(new EventMeshDataInfo(split[0], split[1], v.getAddress() + IP_PORT_SEPARATOR + v.getPort(), 0L, v.getMeta()));
        });
        return eventMeshDataInfos;
    }

    public void registerMetadata(Map<String, String> metadataMap) {
    }

    public Map<String, String> getMetaData(String key, boolean fuzzyEnabled) {
        return null;
    }

    public void updateMetaData(Map<String, String> metadataMap) {
    }

    public void removeMetaData(String key) {
    }

    @Generated
    public ConsulClient getConsulClient() {
        return this.consulClient;
    }
}

