/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.redis.source.connector;

import io.cloudevents.CloudEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.config.connector.redis.RedisSourceConfig;
import org.apache.eventmesh.connector.redis.cloudevent.CloudEventCodec;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.CloudEventUtil;
import org.redisson.Redisson;
import org.redisson.api.RTopic;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.config.Config;

public class RedisSourceConnector
implements Source {
    private RTopic topic;
    private RedisSourceConfig sourceConfig;
    private RedissonClient redissonClient;
    private BlockingQueue<CloudEvent> queue;
    private int maxBatchSize;
    private long maxPollWaitTime;

    public Class<? extends org.apache.eventmesh.common.config.connector.Config> configClass() {
        return RedisSourceConfig.class;
    }

    public void init(org.apache.eventmesh.common.config.connector.Config config) throws Exception {
        this.sourceConfig = (RedisSourceConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (RedisSourceConfig)sourceConnectorContext.getSourceConfig();
        this.doInit();
    }

    private void doInit() {
        Config redisConfig = new Config();
        redisConfig.useSingleServer().setAddress(this.sourceConfig.connectorConfig.getServer());
        redisConfig.setCodec((Codec)CloudEventCodec.getInstance());
        this.redissonClient = Redisson.create((Config)redisConfig);
        this.queue = new LinkedBlockingQueue<CloudEvent>(this.sourceConfig.getPollConfig().getCapacity());
        this.maxBatchSize = this.sourceConfig.getPollConfig().getMaxBatchSize();
        this.maxPollWaitTime = this.sourceConfig.getPollConfig().getMaxWaitTime();
    }

    public void start() throws Exception {
        this.topic = this.redissonClient.getTopic(this.sourceConfig.connectorConfig.getTopic());
        this.topic.addListener(CloudEvent.class, (channel, msg) -> this.queue.add((CloudEvent)msg));
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() throws Exception {
        this.topic.removeAllListeners();
        this.redissonClient.shutdown();
    }

    public List<ConnectRecord> poll() {
        long startTime = System.currentTimeMillis();
        long remainingTime = this.maxPollWaitTime;
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(this.maxBatchSize);
        for (int count = 0; count < this.maxBatchSize; ++count) {
            try {
                CloudEvent event = this.queue.poll(remainingTime, TimeUnit.MILLISECONDS);
                if (event == null) break;
                connectRecords.add(CloudEventUtil.convertEventToRecord((CloudEvent)event));
                long elapsedTime = System.currentTimeMillis() - startTime;
                remainingTime = this.maxPollWaitTime > elapsedTime ? this.maxPollWaitTime - elapsedTime : 0L;
                continue;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return connectRecords;
    }
}

