/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.tcp.common;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.eventmesh.client.tcp.common.MessageUtils;
import org.apache.eventmesh.client.tcp.common.RequestContext;
import org.apache.eventmesh.client.tcp.conf.EventMeshTCPClientConfig;
import org.apache.eventmesh.common.EventMeshThreadFactory;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.protocol.tcp.Package;
import org.apache.eventmesh.common.protocol.tcp.UserAgent;
import org.apache.eventmesh.common.protocol.tcp.codec.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TcpClient
implements Closeable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TcpClient.class);
    protected static int CLIENTNO = 0;
    protected final transient ConcurrentHashMap<Object, RequestContext> contexts = new ConcurrentHashMap();
    protected final transient String host;
    protected final transient int port;
    protected final transient UserAgent userAgent;
    private final transient Bootstrap bootstrap = new Bootstrap();
    private final transient EventLoopGroup workers = new NioEventLoopGroup();
    private transient Channel channel;
    private transient ScheduledFuture<?> heartTask;
    protected static final ScheduledExecutorService scheduler;

    public TcpClient(EventMeshTCPClientConfig eventMeshTcpClientConfig) {
        Preconditions.checkNotNull((Object)eventMeshTcpClientConfig, (Object)"EventMeshTcpClientConfig cannot be null");
        Preconditions.checkNotNull((Object)eventMeshTcpClientConfig.getHost(), (Object)"Host cannot be null");
        Preconditions.checkState((eventMeshTcpClientConfig.getPort() > 0 ? 1 : 0) != 0, (Object)"port is not validated");
        this.host = eventMeshTcpClientConfig.getHost();
        this.port = eventMeshTcpClientConfig.getPort();
        this.userAgent = eventMeshTcpClientConfig.getUserAgent();
    }

    protected synchronized void open(final SimpleChannelInboundHandler<Package> handler) throws Exception {
        this.bootstrap.group(this.workers);
        this.bootstrap.channel(NioSocketChannel.class);
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)1000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_SNDBUF, (Object)65536)).option(ChannelOption.SO_RCVBUF, (Object)65536)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(1024, 8192, 65536))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new Codec.Encoder(), new Codec.Decoder()}).addLast(new ChannelHandler[]{handler, TcpClient.this.newExceptionHandler()});
            }
        });
        ChannelFuture f = this.bootstrap.connect(this.host, this.port).sync();
        InetSocketAddress localAddress = (InetSocketAddress)f.channel().localAddress();
        this.channel = f.channel();
        log.info("connected|local={}:{}|server={}", new Object[]{localAddress.getAddress().getHostAddress(), localAddress.getPort(), this.host + ":" + this.port});
    }

    @Override
    public void close() {
        try {
            this.goodbye();
            this.channel.disconnect().sync();
            this.workers.shutdownGracefully().sync();
            if (this.heartTask != null) {
                this.heartTask.cancel(false);
            }
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
            log.warn("close tcp client failed.|remote address={}", (Object)this.channel.remoteAddress(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void heartbeat() {
        if (this.heartTask != null) return;
        Class<TcpClient> clazz = TcpClient.class;
        synchronized (TcpClient.class) {
            this.heartTask = scheduler.scheduleAtFixedRate(() -> {
                try {
                    if (!this.isActive()) {
                        this.reconnect();
                    }
                    Package msg = MessageUtils.heartBeat();
                    this.io(msg, 20000L);
                    log.debug("heart beat start {}", (Object)msg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, 30000L, 30000L, TimeUnit.MILLISECONDS);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected synchronized void reconnect() throws Exception {
        ChannelFuture f = this.bootstrap.connect(this.host, this.port).sync();
        this.channel = f.channel();
    }

    protected boolean isActive() {
        return this.channel != null && this.channel.isActive();
    }

    protected void send(Package msg) throws Exception {
        if (this.channel.isWritable()) {
            this.channel.writeAndFlush((Object)msg).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (!future.isSuccess()) {
                    log.warn("send msg failed", future.cause());
                }
            }));
        } else {
            this.channel.writeAndFlush((Object)msg).sync();
        }
    }

    protected Package io(Package msg, long timeout) throws Exception {
        RequestContext context;
        Object key = RequestContext.key(msg);
        RequestContext previousContext = this.contexts.putIfAbsent(key, context = RequestContext.context(key, msg));
        if (previousContext != null) {
            log.info("duplicate key : {}", key);
        }
        this.send(msg);
        Supplier<Package> supplier = () -> {
            try {
                return context.getResponse(timeout);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                throw new RuntimeException(exception);
            }
        };
        return CompletableFuture.supplyAsync(supplier).get();
    }

    protected void hello() throws Exception {
        Package msg = MessageUtils.hello(this.userAgent);
        this.io(msg, 20000L);
    }

    protected void goodbye() throws Exception {
        Package msg = MessageUtils.goodbye();
        this.io(msg, 20000L);
    }

    private ChannelDuplexHandler newExceptionHandler() {
        return new ChannelDuplexHandler(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                log.info("exceptionCaught, close connection.|remote address={}", (Object)ctx.channel().remoteAddress(), (Object)cause);
                ctx.close();
            }
        };
    }

    static {
        try {
            CLIENTNO = SecureRandom.getInstanceStrong().nextInt(1000);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Failed to generate a random number!", (Throwable)e);
        }
        scheduler = ThreadPoolFactory.createScheduledExecutor((int)Runtime.getRuntime().availableProcessors(), (ThreadFactory)new EventMeshThreadFactory("TCPClientScheduler", true));
    }
}

