/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.connection.impl;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.connection.impl.AppendBatchSizeTrackerImpl;
import io.pravega.common.util.SimpleCache;
import io.pravega.shared.protocol.netty.AppendBatchSizeTracker;
import java.time.Duration;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlowToBatchSizeTracker {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowToBatchSizeTracker.class);
    private static final Duration TRACKER_CACHE_EXPIRATION_TIME = Duration.ofSeconds(5000L);
    private static final int TRACKER_CACHE_MAX_SIZE = 100000;
    @VisibleForTesting
    private final SimpleCache<Integer, AppendBatchSizeTracker> flowToBatchSizeTrackerMap;

    FlowToBatchSizeTracker() {
        this.flowToBatchSizeTrackerMap = new SimpleCache(100000, TRACKER_CACHE_EXPIRATION_TIME, (flow, tracker) -> log.info("Evicting batch tracker for flow: {}", flow));
    }

    @VisibleForTesting
    FlowToBatchSizeTracker(int flowCacheMaxSize, Duration flowCacheExpiration, BiConsumer<Integer, AppendBatchSizeTracker> callback) {
        this.flowToBatchSizeTrackerMap = new SimpleCache(flowCacheMaxSize, flowCacheExpiration, callback);
    }

    AppendBatchSizeTracker getAppendBatchSizeTrackerByFlowId(int flowId) {
        if (this.flowToBatchSizeTrackerMap.putIfAbsent((Object)flowId, (Object)new AppendBatchSizeTrackerImpl()) == null) {
            log.debug("Instantiating new batch sze tracker for flow: {}", (Object)flowId);
        }
        return (AppendBatchSizeTracker)this.flowToBatchSizeTrackerMap.get((Object)flowId);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    SimpleCache<Integer, AppendBatchSizeTracker> getFlowToBatchSizeTrackerMap() {
        return this.flowToBatchSizeTrackerMap;
    }
}

