/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.Position;
import io.pravega.client.stream.impl.PositionInternal;
import io.pravega.client.stream.impl.SegmentWithRange;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.common.util.ToStringUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class PositionImpl
extends PositionInternal {
    private static final PositionSerializer SERIALIZER = new PositionSerializer();
    private Map<Segment, Long> ownedSegments;
    private final Map<Segment, SegmentWithRange.Range> segmentRanges;
    private transient List<Map.Entry<Segment, Long>> updatesToSegmentOffsets;
    private transient long version;

    public PositionImpl(Map<SegmentWithRange, Long> segments) {
        this.ownedSegments = new HashMap<Segment, Long>(segments.size());
        this.segmentRanges = new HashMap<Segment, SegmentWithRange.Range>(segments.size());
        this.updatesToSegmentOffsets = null;
        this.version = 0L;
        for (Map.Entry<SegmentWithRange, Long> entry : segments.entrySet()) {
            SegmentWithRange s = entry.getKey();
            this.ownedSegments.put(s.getSegment(), entry.getValue());
            this.segmentRanges.put(s.getSegment(), s.getRange());
        }
    }

    PositionImpl(Map<Segment, Long> ownedSegments, Map<Segment, SegmentWithRange.Range> segmentRanges, List<Map.Entry<Segment, Long>> updatesToSegmentOffsets) {
        this.ownedSegments = Collections.unmodifiableMap(ownedSegments);
        this.updatesToSegmentOffsets = updatesToSegmentOffsets != null ? Collections.unmodifiableList(updatesToSegmentOffsets) : null;
        this.version = updatesToSegmentOffsets != null ? (long)updatesToSegmentOffsets.size() : 0L;
        this.segmentRanges = segmentRanges == null ? Collections.emptyMap() : Collections.unmodifiableMap(segmentRanges);
    }

    @Override
    public Set<Segment> getOwnedSegments() {
        this.applySegmentOffsetUpdatesIfNeeded();
        return Collections.unmodifiableSet(this.ownedSegments.keySet());
    }

    @Override
    public Map<Segment, Long> getOwnedSegmentsWithOffsets() {
        this.applySegmentOffsetUpdatesIfNeeded();
        return Collections.unmodifiableMap(this.ownedSegments);
    }

    @Override
    Map<SegmentWithRange, Long> getOwnedSegmentRangesWithOffsets() {
        this.applySegmentOffsetUpdatesIfNeeded();
        HashMap<SegmentWithRange, Long> result = new HashMap<SegmentWithRange, Long>();
        for (Map.Entry<Segment, Long> entry : this.ownedSegments.entrySet()) {
            result.put(new SegmentWithRange(entry.getKey(), this.segmentRanges.get(entry.getKey())), entry.getValue());
        }
        return result;
    }

    @Override
    public Set<Segment> getCompletedSegments() {
        this.applySegmentOffsetUpdatesIfNeeded();
        return this.ownedSegments.entrySet().stream().filter(x -> (Long)x.getValue() < 0L).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public Long getOffsetForOwnedSegment(Segment segmentId) {
        this.applySegmentOffsetUpdatesIfNeeded();
        return this.ownedSegments.get(segmentId);
    }

    @Override
    public PositionImpl asImpl() {
        this.applySegmentOffsetUpdatesIfNeeded();
        return this;
    }

    public String toString() {
        this.applySegmentOffsetUpdatesIfNeeded();
        return ToStringUtils.mapToString(this.ownedSegments);
    }

    public boolean equals(Object o) {
        this.applySegmentOffsetUpdatesIfNeeded();
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PositionImpl position = (PositionImpl)o;
        return this.ownedSegments.equals(position.getOwnedSegmentsWithOffsets()) && this.segmentRanges.equals(position.segmentRanges);
    }

    public int hashCode() {
        this.applySegmentOffsetUpdatesIfNeeded();
        return Objects.hash(this.ownedSegments, this.segmentRanges);
    }

    @Override
    public ByteBuffer toBytes() {
        ByteArraySegment serialized = SERIALIZER.serialize(this);
        return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
    }

    public static Position fromBytes(ByteBuffer buff) {
        return (Position)SERIALIZER.deserialize((BufferView)new ByteArraySegment(buff));
    }

    private synchronized void applySegmentOffsetUpdatesIfNeeded() {
        if (this.updatesToSegmentOffsets == null || this.updatesToSegmentOffsets.isEmpty()) {
            return;
        }
        HashMap<Segment, Long> newOwnedSegments = new HashMap<Segment, Long>();
        for (int i = (int)this.version - 1; i >= 0; --i) {
            newOwnedSegments.putIfAbsent(this.updatesToSegmentOffsets.get(i).getKey(), this.updatesToSegmentOffsets.get(i).getValue());
            if (newOwnedSegments.size() == this.ownedSegments.size()) break;
        }
        if (newOwnedSegments.size() < this.ownedSegments.size()) {
            for (Map.Entry<Segment, Long> s : this.ownedSegments.entrySet()) {
                newOwnedSegments.putIfAbsent(s.getKey(), s.getValue());
            }
        }
        this.ownedSegments = Collections.unmodifiableMap(newOwnedSegments);
        this.updatesToSegmentOffsets = null;
        this.version = 0L;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static PositionBuilder builder() {
        return new PositionBuilder();
    }

    private static class PositionSerializer
    extends VersionedSerializer.WithBuilder<PositionImpl, PositionBuilder> {
        private PositionSerializer() {
        }

        protected PositionBuilder newBuilder() {
            return PositionImpl.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00).revision(1, this::write01, this::read01);
        }

        private void read00(RevisionDataInput revisionDataInput, PositionBuilder builder) throws IOException {
            Map map = revisionDataInput.readMap(in -> Segment.fromScopedName(in.readUTF()), in -> {
                long offset = in.readCompactLong();
                if (offset == 0x3FFFFFFFFFFFFFFEL) {
                    return -1L;
                }
                return offset;
            });
            builder.ownedSegments(map);
        }

        private void write00(PositionImpl position, RevisionDataOutput revisionDataOutput) throws IOException {
            Map<Segment, Long> map = position.getOwnedSegmentsWithOffsets();
            revisionDataOutput.writeMap(map, (out, s) -> out.writeUTF(s.getScopedName()), (out, offset) -> {
                if (offset < 0L) {
                    out.writeCompactLong(0x3FFFFFFFFFFFFFFEL);
                } else {
                    out.writeCompactLong(offset.longValue());
                }
            });
        }

        private void read01(RevisionDataInput revisionDataInput, PositionBuilder builder) throws IOException {
            Map map = revisionDataInput.readMap(in -> Segment.fromScopedName(in.readUTF()), PositionSerializer::readRange);
            builder.segmentRanges(map);
        }

        private void write01(PositionImpl position, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeMap(position.segmentRanges, (out, s) -> out.writeUTF(s.getScopedName()), PositionSerializer::writeRange);
        }

        private static void writeRange(RevisionDataOutput out, SegmentWithRange.Range range) throws IOException {
            double high;
            double low;
            if (range == null) {
                low = -1.0;
                high = -1.0;
            } else {
                low = range.getLow();
                high = range.getHigh();
            }
            out.writeDouble(low);
            out.writeDouble(high);
        }

        private static SegmentWithRange.Range readRange(RevisionDataInput in) throws IOException {
            double low = in.readDouble();
            double high = in.readDouble();
            return low < 0.0 || high < 0.0 ? null : new SegmentWithRange.Range(low, high);
        }
    }

    static class PositionBuilder
    implements ObjectBuilder<PositionImpl> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<Segment, Long> ownedSegments;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<Segment, SegmentWithRange.Range> segmentRanges;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<Map.Entry<Segment, Long>> updatesToSegmentOffsets;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        PositionBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PositionBuilder ownedSegments(Map<Segment, Long> ownedSegments) {
            this.ownedSegments = ownedSegments;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PositionBuilder segmentRanges(Map<Segment, SegmentWithRange.Range> segmentRanges) {
            this.segmentRanges = segmentRanges;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PositionBuilder updatesToSegmentOffsets(List<Map.Entry<Segment, Long>> updatesToSegmentOffsets) {
            this.updatesToSegmentOffsets = updatesToSegmentOffsets;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public PositionImpl build() {
            return new PositionImpl(this.ownedSegments, this.segmentRanges, this.updatesToSegmentOffsets);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "PositionImpl.PositionBuilder(ownedSegments=" + this.ownedSegments + ", segmentRanges=" + this.segmentRanges + ", updatesToSegmentOffsets=" + this.updatesToSegmentOffsets + ")";
        }
    }
}

