/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.admin.KeyValueTableInfo;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.tables.impl.KeyValueTableSegments;
import io.pravega.client.tables.impl.TableSegment;
import io.pravega.client.tables.impl.TableSegmentFactory;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import lombok.NonNull;

class SegmentSelector
implements AutoCloseable {
    private final KeyValueTableInfo kvt;
    private final TableSegmentFactory tableSegmentFactory;
    private final KeyValueTableSegments segmentsByRange;
    @GuardedBy(value="segments")
    private final Map<Segment, TableSegment> segments = new HashMap<Segment, TableSegment>();
    private final AtomicBoolean closed;

    SegmentSelector(@NonNull KeyValueTableInfo kvt, @NonNull Controller controller, @NonNull TableSegmentFactory tableSegmentFactory) {
        if (kvt == null) {
            throw new NullPointerException("kvt is marked non-null but is null");
        }
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (tableSegmentFactory == null) {
            throw new NullPointerException("tableSegmentFactory is marked non-null but is null");
        }
        this.kvt = kvt;
        this.tableSegmentFactory = tableSegmentFactory;
        this.segmentsByRange = this.initializeSegments(kvt, controller);
        assert (this.segmentsByRange != null);
        this.closed = new AtomicBoolean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            ArrayList<TableSegment> toClose;
            Map<Segment, TableSegment> map = this.segments;
            synchronized (map) {
                toClose = new ArrayList<TableSegment>(this.segments.values());
                this.segments.clear();
            }
            toClose.forEach(TableSegment::close);
        }
    }

    TableSegment getTableSegment(@NonNull ByteBuffer key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        Segment s = this.segmentsByRange.getSegmentForKey(key.duplicate());
        return this.getTableSegment(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableSegment getTableSegment(Segment s) {
        Map<Segment, TableSegment> map = this.segments;
        synchronized (map) {
            TableSegment ts = this.segments.get(s);
            if (ts == null) {
                ts = this.tableSegmentFactory.forSegment(s);
                this.segments.put(s, ts);
            }
            return ts;
        }
    }

    Collection<TableSegment> getAllTableSegments() {
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        return this.segmentsByRange.getSegments().stream().map(this::getTableSegment).collect(Collectors.toList());
    }

    int getSegmentCount() {
        return this.segmentsByRange.getSegmentCount();
    }

    private KeyValueTableSegments initializeSegments(KeyValueTableInfo kvt, Controller controller) {
        return (KeyValueTableSegments)Futures.getAndHandleExceptions(controller.getCurrentSegmentsForKeyValueTable(kvt.getScope(), kvt.getKeyValueTableName()), RuntimeException::new);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public KeyValueTableInfo getKvt() {
        return this.kvt;
    }
}

