/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.eventmesh.common.EventMeshThreadFactory;

public abstract class ThreadPoolFactory {
    private ThreadPoolFactory() {
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(int core, int max, String threadName) {
        return ThreadPoolFactory.createThreadPoolExecutor(core, max, threadName, true);
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(int core, int max, String threadName, boolean isDaemon) {
        return ThreadPoolFactory.createThreadPoolExecutor(core, max, new LinkedBlockingQueue<Runnable>(1000), threadName, isDaemon);
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(int core, int max, BlockingQueue<Runnable> blockingQueue, String threadName, boolean isDaemon) {
        return new ThreadPoolExecutor(core, max, 10000L, TimeUnit.MILLISECONDS, blockingQueue, new EventMeshThreadFactory(threadName, isDaemon));
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(int core, int max, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        return new ThreadPoolExecutor(core, max, 10000L, TimeUnit.MILLISECONDS, blockingQueue, threadFactory);
    }

    public static ScheduledExecutorService createSingleScheduledExecutor(String threadName) {
        return Executors.newSingleThreadScheduledExecutor(new EventMeshThreadFactory(threadName, true));
    }

    public static ScheduledExecutorService createScheduledExecutor(int core, ThreadFactory threadFactory) {
        return Executors.newScheduledThreadPool(core, threadFactory);
    }

    public static ExecutorService createSingleExecutor(String threadName) {
        return Executors.newSingleThreadExecutor(new EventMeshThreadFactory(threadName));
    }
}

