/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.util.argument;

import com.navercorp.pinpoint.bootstrap.util.argument.Predicate;
import com.navercorp.pinpoint.bootstrap.util.argument.Validator;
import java.util.List;

public class ArgumentValidator
implements Validator {
    private final Predicate[] predicates;
    private final int minArgsSize;

    public ArgumentValidator(List<Predicate> argumentList) {
        this(argumentList, 0);
    }

    public ArgumentValidator(List<Predicate> predicates, int minArgsSize) {
        this.predicates = predicates.toArray(new Predicate[0]);
        this.minArgsSize = ArgumentValidator.minIndex(this.predicates, minArgsSize);
    }

    private static int minIndex(Predicate[] predicates, int minArgsSize) {
        if (minArgsSize != 0) {
            return minArgsSize;
        }
        int max = -1;
        for (Predicate predicate : predicates) {
            max = Math.max(max, predicate.index());
        }
        return max + 1;
    }

    @Override
    public boolean validate(Object[] args) {
        if (args == null) {
            return false;
        }
        if (args.length < this.minArgsSize) {
            return false;
        }
        for (Predicate predicate : this.predicates) {
            if (predicate.test(args)) continue;
            return false;
        }
        return true;
    }
}

