/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.wecom.sink.connector;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.wecom.WeComSinkConfig;
import org.apache.eventmesh.common.enums.EventMeshDataContentType;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.connector.wecom.config.WeComMessageTemplateType;
import org.apache.eventmesh.connector.wecom.sink.connector.SendMessageRequest;
import org.apache.eventmesh.connector.wecom.sink.connector.SendMessageResponse;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeComSinkConnector
implements Sink {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WeComSinkConnector.class);
    private static final String ROBOT_WEBHOOK_URL_PREFIX = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=";
    private CloseableHttpClient httpClient;
    private WeComSinkConfig sinkConfig;
    private volatile boolean isRunning = false;

    public Class<? extends Config> configClass() {
        return WeComSinkConfig.class;
    }

    public void init(Config config) {
        this.sinkConfig = (WeComSinkConfig)config;
        this.httpClient = HttpClientBuilder.create().build();
    }

    public void init(ConnectorContext connectorContext) {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (WeComSinkConfig)sinkConnectorContext.getSinkConfig();
        this.httpClient = HttpClientBuilder.create().build();
    }

    public void start() {
        this.isRunning = true;
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getSinkConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() throws IOException {
        this.isRunning = false;
        this.httpClient.close();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord record : sinkRecords) {
            try {
                if (Objects.isNull(record.getData())) {
                    log.warn("ConnectRecord data is null, ignore.");
                    continue;
                }
                this.sendMessage(record);
            }
            catch (Exception e) {
                log.error("Failed to sink message to WeCom.", (Throwable)e);
            }
        }
    }

    private void sendMessage(ConnectRecord record) {
        String target = ROBOT_WEBHOOK_URL_PREFIX + this.sinkConfig.getSinkConnectorConfig().getRobotWebhookKey();
        SendMessageRequest request = new SendMessageRequest();
        HttpPost httpPost = new HttpPost(target);
        httpPost.addHeader("Content-Type", EventMeshDataContentType.JSON.getCode());
        WeComMessageTemplateType templateType = WeComMessageTemplateType.of(Optional.ofNullable(record.getExtension("wecomtemplatetype")).orElse(WeComMessageTemplateType.PLAIN_TEXT.getTemplateType()));
        HashMap<String, Object> contentMap = new HashMap<String, Object>();
        if (WeComMessageTemplateType.PLAIN_TEXT == templateType) {
            contentMap.put("content", new String((byte[])record.getData()));
            request.setTextContent(contentMap);
        } else if (WeComMessageTemplateType.MARKDOWN == templateType) {
            contentMap.put("content", new String((byte[])record.getData()));
            request.setMarkdownContent(contentMap);
        }
        request.setMessageType(templateType.getTemplateKey());
        httpPost.setEntity((HttpEntity)new StringEntity(Objects.requireNonNull(JsonUtils.toJSONString((Object)request)), ContentType.APPLICATION_JSON));
        CloseableHttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
        String resultStr = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)Constants.DEFAULT_CHARSET);
        SendMessageResponse sendMessageResponse = Objects.requireNonNull((SendMessageResponse)JsonUtils.parseObject((String)resultStr, SendMessageResponse.class));
        if (sendMessageResponse.getErrorCode() != 0) {
            throw new IllegalAccessException(String.format("Send message to weCom error! errorCode=%s, errorMessage=%s", sendMessageResponse.getErrorCode(), sendMessageResponse.getErrorMessage()));
        }
    }
}

