/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog.event;

import com.taobao.tddl.dbsync.binlog.LogBuffer;
import com.taobao.tddl.dbsync.binlog.event.FormatDescriptionLogEvent;
import com.taobao.tddl.dbsync.binlog.event.LoadLogEvent;
import com.taobao.tddl.dbsync.binlog.event.LogHeader;

public final class CreateFileLogEvent
extends LoadLogEvent {
    protected LogBuffer blockBuf;
    protected int blockLen;
    protected long fileId;
    protected boolean initedFromOld;
    public static final int CF_FILE_ID_OFFSET = 0;
    public static final int CF_DATA_OFFSET = 4;

    public CreateFileLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) {
        super(header, buffer, descriptionEvent);
        int headerLen = descriptionEvent.commonHeaderLen;
        short loadHeaderLen = descriptionEvent.postHeaderLen[5];
        short createFileHeaderLen = descriptionEvent.postHeaderLen[7];
        this.copyLogEvent(buffer, header.type == 6 ? loadHeaderLen + headerLen : headerLen + loadHeaderLen + createFileHeaderLen, descriptionEvent);
        if (descriptionEvent.binlogVersion != 1) {
            this.fileId = buffer.getUint32(headerLen + loadHeaderLen + 0);
            this.blockLen = buffer.limit() - buffer.position();
            this.blockBuf = buffer.duplicate(this.blockLen);
        } else {
            this.initedFromOld = true;
        }
    }

    public final long getFileId() {
        return this.fileId;
    }

    public final LogBuffer getBuffer() {
        return this.blockBuf;
    }

    public final byte[] getData() {
        return this.blockBuf.getData();
    }
}

