/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog.event;

import com.taobao.tddl.dbsync.binlog.LogBuffer;
import com.taobao.tddl.dbsync.binlog.LogEvent;
import com.taobao.tddl.dbsync.binlog.event.FormatDescriptionLogEvent;
import com.taobao.tddl.dbsync.binlog.event.LogHeader;

public final class RotateLogEvent
extends LogEvent {
    private final String filename;
    private final long position;
    public static final int R_POS_OFFSET = 0;
    public static final int R_IDENT_OFFSET = 8;
    public static final int FN_REFLEN = 512;
    public static final LogHeader ROTATE_HEADER = new LogHeader(4);

    public RotateLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) {
        super(header);
        int headerSize = descriptionEvent.commonHeaderLen;
        short postHeaderLen = descriptionEvent.postHeaderLen[3];
        buffer.position(headerSize + 0);
        this.position = postHeaderLen != 0 ? buffer.getLong64() : 4L;
        int filenameOffset = headerSize + postHeaderLen;
        int filenameLen = buffer.limit() - filenameOffset;
        if (filenameLen > 511) {
            filenameLen = 511;
        }
        buffer.position(filenameOffset);
        this.filename = buffer.getFixString(filenameLen);
    }

    public RotateLogEvent(String filename) {
        super(ROTATE_HEADER);
        this.filename = filename;
        this.position = 4L;
    }

    public RotateLogEvent(String filename, long position) {
        super(ROTATE_HEADER);
        this.filename = filename;
        this.position = position;
    }

    public final String getFilename() {
        return this.filename;
    }

    public final long getPosition() {
        return this.position;
    }
}

