/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.meta.raft;

import com.alipay.remoting.exception.CodecException;
import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.entity.Task;
import com.alipay.sofa.jraft.error.RaftError;
import java.nio.ByteBuffer;
import org.apache.eventmesh.meta.raft.EventClosure;
import org.apache.eventmesh.meta.raft.EventOperation;
import org.apache.eventmesh.meta.raft.JraftMetaService;
import org.apache.eventmesh.meta.raft.JraftServer;
import org.apache.eventmesh.meta.raft.rpc.RequestResponse;
import org.apache.eventmesh.meta.raft.serialize.EventMeshHessianSerializer;

public class JraftMetaServiceImpl
implements JraftMetaService {
    JraftServer server;

    public JraftMetaServiceImpl(JraftServer server) {
        this.server = server;
    }

    @Override
    public void handle(RequestResponse request, EventClosure closure) {
        this.applyOperation(EventOperation.createOpreation(request), closure);
    }

    public void applyOperation(EventOperation opreation, EventClosure closure) {
        if (!this.isLeader()) {
            this.handlerNotLeaderError(closure);
            return;
        }
        try {
            closure.setEventOperation(opreation);
            Task task = new Task();
            task.setData(ByteBuffer.wrap(EventMeshHessianSerializer.getInstance().serialize((Object)opreation)));
            task.setDone((Closure)closure);
            this.server.getNode().apply(task);
        }
        catch (CodecException e) {
            String errorMsg = "Fail to encode EventOperation";
            closure.failure(errorMsg, "");
            closure.run(new Status(RaftError.EINTERNAL, errorMsg, new Object[0]));
        }
    }

    private String getRedirect() {
        return this.server.redirect().getRedirect();
    }

    private boolean isLeader() {
        return this.server.getFsm().isLeader();
    }

    private void handlerNotLeaderError(EventClosure closure) {
        closure.failure("Not leader.", this.getRedirect());
        closure.run(new Status(RaftError.EPERM, "Not leader", new Object[0]));
    }
}

