/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.admin.netty;

import com.alibaba.otter.canal.admin.CanalAdmin;
import com.alibaba.otter.canal.admin.handler.ClientAuthenticationHandler;
import com.alibaba.otter.canal.admin.handler.HandshakeInitializationHandler;
import com.alibaba.otter.canal.admin.handler.SessionHandler;
import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.server.netty.handler.FixedHeaderFrameDecoder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class CanalAdminWithNetty
extends AbstractCanalLifeCycle {
    private String ip;
    private int port;
    private Channel serverChannel = null;
    private ServerBootstrap bootstrap = null;
    private ChannelGroup childGroups = new DefaultChannelGroup();
    private CanalAdmin canalAdmin;

    private CanalAdminWithNetty() {
    }

    public static CanalAdminWithNetty instance() {
        return SingletonHolder.CANAL_ADMIN_WITH_NETTY;
    }

    public void start() {
        super.start();
        this.bootstrap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        this.bootstrap.setOption("child.keepAlive", (Object)true);
        this.bootstrap.setOption("child.tcpNoDelay", (Object)true);
        this.bootstrap.setPipelineFactory(() -> {
            ChannelPipeline pipelines = Channels.pipeline();
            pipelines.addLast(FixedHeaderFrameDecoder.class.getName(), (ChannelHandler)new FixedHeaderFrameDecoder());
            pipelines.addLast(HandshakeInitializationHandler.class.getName(), (ChannelHandler)new HandshakeInitializationHandler(this.childGroups));
            pipelines.addLast(ClientAuthenticationHandler.class.getName(), (ChannelHandler)new ClientAuthenticationHandler(this.canalAdmin));
            SessionHandler sessionHandler = new SessionHandler(this.canalAdmin);
            pipelines.addLast(SessionHandler.class.getName(), (ChannelHandler)sessionHandler);
            return pipelines;
        });
        this.serverChannel = StringUtils.isNotEmpty((String)this.ip) ? this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.ip, this.port)) : this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
    }

    public void stop() {
        super.stop();
        if (this.serverChannel != null) {
            this.serverChannel.close().awaitUninterruptibly(1000L);
        }
        if (this.childGroups != null) {
            this.childGroups.close().awaitUninterruptibly(5000L);
        }
        if (this.bootstrap != null) {
            this.bootstrap.releaseExternalResources();
        }
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setCanalAdmin(CanalAdmin canalAdmin) {
        this.canalAdmin = canalAdmin;
    }

    private static class SingletonHolder {
        private static final CanalAdminWithNetty CANAL_ADMIN_WITH_NETTY = new CanalAdminWithNetty();

        private SingletonHolder() {
        }
    }
}

