/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.table.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.catalog.Options;
import org.apache.eventmesh.connector.jdbc.table.catalog.PrimaryKey;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableEditor;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableSchema;
import org.apache.eventmesh.connector.jdbc.table.catalog.UniqueKey;

public abstract class AbstractTableEditorImpl<TE extends TableEditor, Col extends Column, TB extends TableSchema>
implements TableEditor<TE, Col, TB> {
    private TableId tableId;
    private PrimaryKey primaryKey = new PrimaryKey();
    private List<UniqueKey> uniqueKeys = new ArrayList<UniqueKey>(8);
    private Map<String, Col> columns = new HashMap<String, Col>(16);
    private String comment;
    private Options options = new Options();

    public AbstractTableEditorImpl(TableId tableId) {
        this.tableId = tableId;
    }

    public AbstractTableEditorImpl() {
    }

    @Override
    public TE withTableId(TableId tableId) {
        this.tableId = tableId;
        return (TE)this;
    }

    @Override
    public TE addColumns(Col ... columns) {
        if (columns != null && columns.length > 0) {
            for (Col column : columns) {
                this.columns.put(((Column)column).getName(), column);
            }
        }
        return (TE)this;
    }

    @Override
    public TE withComment(String comment) {
        this.comment = comment;
        return (TE)this;
    }

    @Override
    public TE removeColumn(String columnName) {
        this.columns.remove(columnName);
        return (TE)this;
    }

    @Override
    public TE withPrimaryKeyNames(List<String> pkColumnNames, String comment) {
        this.primaryKey = new PrimaryKey(pkColumnNames, comment);
        return (TE)this;
    }

    @Override
    public TE withPrimaryKeyNames(String ... pkColumnNames) {
        if (pkColumnNames != null && pkColumnNames.length > 0) {
            this.primaryKey.addColumnNames(pkColumnNames);
        }
        return (TE)this;
    }

    @Override
    public TE withPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
        return (TE)this;
    }

    @Override
    public TE withUniqueKeyColumnsNames(String ukName, List<String> ukColumnNames, String comment) {
        this.uniqueKeys.add(new UniqueKey(ukName, ukColumnNames, comment));
        return (TE)this;
    }

    @Override
    public TE withUniqueKeys(UniqueKey ... uniqueKeys) {
        if (uniqueKeys != null && uniqueKeys.length > 0) {
            for (UniqueKey uniqueKey : uniqueKeys) {
                this.uniqueKeys.add(uniqueKey);
            }
        }
        return (TE)this;
    }

    @Override
    public TE withOption(String key, Object value) {
        this.options.put(key, value);
        return (TE)this;
    }

    protected TableId ofTableId() {
        return this.tableId;
    }

    protected PrimaryKey ofPrimaryKey() {
        return this.primaryKey;
    }

    protected List<UniqueKey> ofUniqueKeys() {
        return this.uniqueKeys;
    }

    protected Map<String, Col> ofColumns() {
        return this.columns;
    }

    protected String ofComment() {
        return this.comment;
    }

    protected Options ofOptions() {
        return this.options;
    }
}

