/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.table.catalog;

import java.util.List;
import lombok.Generated;
import org.apache.eventmesh.connector.jdbc.table.catalog.Options;
import org.apache.eventmesh.connector.jdbc.table.catalog.PrimaryKey;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.connector.jdbc.table.catalog.UniqueKey;

public class Table {
    private TableId tableId;
    private PrimaryKey primaryKey;
    private List<UniqueKey> uniqueKeys;
    private String comment;
    private Options options = new Options();

    public Table(TableId tableId, PrimaryKey primaryKey, List<UniqueKey> uniqueKeys, String comment) {
        this.tableId = tableId;
        this.primaryKey = primaryKey;
        this.uniqueKeys = uniqueKeys;
        this.comment = comment;
    }

    public Table(TableId tableId, PrimaryKey primaryKey, List<UniqueKey> uniqueKeys, String comment, Options options) {
        this.tableId = tableId;
        this.primaryKey = primaryKey;
        this.uniqueKeys = uniqueKeys;
        this.comment = comment;
        if (options != null) {
            this.options.putAll(options);
        }
    }

    public void put(String key, Object value) {
        this.options.put(key, value);
    }

    public void putAll(Options options) {
        this.options.putAll(options);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Generated
    public TableId getTableId() {
        return this.tableId;
    }

    @Generated
    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    @Generated
    public List<UniqueKey> getUniqueKeys() {
        return this.uniqueKeys;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public Options getOptions() {
        return this.options;
    }

    @Generated
    public void setTableId(TableId tableId) {
        this.tableId = tableId;
    }

    @Generated
    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Generated
    public void setUniqueKeys(List<UniqueKey> uniqueKeys) {
        this.uniqueKeys = uniqueKeys;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setOptions(Options options) {
        this.options = options;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TableId this$tableId = this.getTableId();
        TableId other$tableId = other.getTableId();
        if (this$tableId == null ? other$tableId != null : !((Object)this$tableId).equals(other$tableId)) {
            return false;
        }
        PrimaryKey this$primaryKey = this.getPrimaryKey();
        PrimaryKey other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        List<UniqueKey> this$uniqueKeys = this.getUniqueKeys();
        List<UniqueKey> other$uniqueKeys = other.getUniqueKeys();
        if (this$uniqueKeys == null ? other$uniqueKeys != null : !((Object)this$uniqueKeys).equals(other$uniqueKeys)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Options this$options = this.getOptions();
        Options other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Table;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TableId $tableId = this.getTableId();
        result = result * 59 + ($tableId == null ? 43 : ((Object)$tableId).hashCode());
        PrimaryKey $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        List<UniqueKey> $uniqueKeys = this.getUniqueKeys();
        result = result * 59 + ($uniqueKeys == null ? 43 : ((Object)$uniqueKeys).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Options $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Table(tableId=" + this.getTableId() + ", primaryKey=" + this.getPrimaryKey() + ", uniqueKeys=" + this.getUniqueKeys() + ", comment=" + this.getComment() + ", options=" + this.getOptions() + ")";
    }

    @Generated
    public Table() {
    }

    public static class Builder {
        private TableId tableId;
        private PrimaryKey primaryKey;
        private List<UniqueKey> uniqueKeys;
        private String comment;
        private Options options;

        public Builder withTableId(TableId tableId) {
            this.tableId = tableId;
            return this;
        }

        public Builder withPrimaryKey(PrimaryKey primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public Builder withUniqueKeys(List<UniqueKey> uniqueKeys) {
            this.uniqueKeys = uniqueKeys;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder withOptions(Options options) {
            this.options = options;
            return this;
        }

        public Table build() {
            return new Table(this.tableId, this.primaryKey, this.uniqueKeys, this.comment, this.options);
        }
    }
}

