/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.visitor.functions;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.visitor.SQLEvalVisitor;
import com.alibaba.druid.sql.visitor.functions.Function;
import java.math.BigDecimal;

public class Char
implements Function {
    public static final Char instance = new Char();

    @Override
    public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
        if (x.getArguments().isEmpty()) {
            return SQLEvalVisitor.EVAL_ERROR;
        }
        StringBuffer buf = new StringBuffer(x.getArguments().size());
        for (SQLExpr param : x.getArguments()) {
            param.accept(visitor);
            Object paramValue = param.getAttributes().get("eval.value");
            if (paramValue instanceof Number) {
                int charCode = ((Number)paramValue).intValue();
                buf.append((char)charCode);
                continue;
            }
            if (paramValue instanceof String) {
                try {
                    int charCode = new BigDecimal((String)paramValue).intValue();
                    buf.append((char)charCode);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            return SQLEvalVisitor.EVAL_ERROR;
        }
        return buf.toString();
    }
}

