/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.redisson.RedissonBlockingDeque;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonBucket;
import org.redisson.RedissonDeque;
import org.redisson.RedissonGeo;
import org.redisson.RedissonList;
import org.redisson.RedissonMap;
import org.redisson.RedissonQueue;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonSet;
import org.redisson.RedissonStream;
import org.redisson.api.RBlockingDeque;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RBucket;
import org.redisson.api.RClientSideCaching;
import org.redisson.api.RDeque;
import org.redisson.api.RGeo;
import org.redisson.api.RList;
import org.redisson.api.RMap;
import org.redisson.api.RQueue;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.RSet;
import org.redisson.api.RStream;
import org.redisson.api.listener.TrackingListener;
import org.redisson.api.options.ClientSideCachingOptions;
import org.redisson.api.options.ClientSideCachingParams;
import org.redisson.cache.CacheKeyParams;
import org.redisson.cache.LFUCacheMap;
import org.redisson.cache.LRUCacheMap;
import org.redisson.cache.NoneCacheMap;
import org.redisson.cache.ReferenceCacheMap;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.pubsub.PublishSubscribeService;

public final class RedissonClientSideCaching
implements RClientSideCaching {
    Map<CacheKeyParams, Object> cache;
    final Map<String, Set<CacheKeyParams>> name2cacheKey = new ConcurrentHashMap<String, Set<CacheKeyParams>>();
    final CommandAsyncExecutor commandExecutor;
    final int listenerId;

    RedissonClientSideCaching(CommandAsyncExecutor commandExecutor, ClientSideCachingOptions options) {
        ClientSideCachingParams params = (ClientSideCachingParams)options;
        if (params.getEvictionPolicy() == ClientSideCachingOptions.EvictionPolicy.NONE) {
            this.cache = new NoneCacheMap<CacheKeyParams, Object>(params.getTtl(), params.getIdleTime());
        }
        if (params.getEvictionPolicy() == ClientSideCachingOptions.EvictionPolicy.LRU) {
            this.cache = new LRUCacheMap<CacheKeyParams, Object>(params.getSize(), params.getTtl(), params.getIdleTime());
        }
        if (params.getEvictionPolicy() == ClientSideCachingOptions.EvictionPolicy.LFU) {
            this.cache = new LFUCacheMap<CacheKeyParams, Object>(params.getSize(), params.getTtl(), params.getIdleTime());
        }
        if (params.getEvictionPolicy() == ClientSideCachingOptions.EvictionPolicy.SOFT) {
            this.cache = ReferenceCacheMap.soft(params.getTtl(), params.getIdleTime());
        }
        if (params.getEvictionPolicy() == ClientSideCachingOptions.EvictionPolicy.WEAK) {
            this.cache = ReferenceCacheMap.weak(params.getTtl(), params.getIdleTime());
        }
        CommandAsyncExecutor tracked = commandExecutor.copy(true);
        this.commandExecutor = this.create(tracked, CommandAsyncExecutor.class);
        PublishSubscribeService subscribeService = this.commandExecutor.getConnectionManager().getSubscribeService();
        CompletableFuture<Integer> r = subscribeService.subscribe(this.commandExecutor, new TrackingListener(){

            @Override
            public void onChange(String name) {
                Set<CacheKeyParams> keys = RedissonClientSideCaching.this.name2cacheKey.remove(name);
                if (keys == null) {
                    return;
                }
                for (CacheKeyParams key : keys) {
                    RedissonClientSideCaching.this.cache.remove(key);
                }
            }
        });
        this.listenerId = r.join();
    }

    public <T> T create(final Object instance, Class<T> clazz) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (!method.getName().contains("read")) {
                    return method.invoke(instance, args);
                }
                String name = Arrays.stream(args).filter(r -> r instanceof String).findFirst().orElse(null);
                if (name == null) {
                    return method.invoke(instance, args);
                }
                CacheKeyParams key = new CacheKeyParams(args);
                Set values = RedissonClientSideCaching.this.name2cacheKey.computeIfAbsent(name, v -> Collections.newSetFromMap(new ConcurrentHashMap()));
                values.add(key);
                return RedissonClientSideCaching.this.cache.computeIfAbsent(key, k -> {
                    try {
                        return method.invoke(instance, args);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new IllegalStateException(e);
                    }
                });
            }
        };
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, handler);
    }

    @Override
    public <V> RBucket<V> getBucket(String name) {
        return new RedissonBucket(this.commandExecutor, name);
    }

    @Override
    public <V> RBucket<V> getBucket(String name, Codec codec) {
        return new RedissonBucket(codec, this.commandExecutor, name);
    }

    @Override
    public <K, V> RStream<K, V> getStream(String name) {
        return new RedissonStream(this.commandExecutor, name);
    }

    @Override
    public <K, V> RStream<K, V> getStream(String name, Codec codec) {
        return new RedissonStream(codec, this.commandExecutor, name);
    }

    @Override
    public <V> RSet<V> getSet(String name) {
        return new RedissonSet(this.commandExecutor, name, null);
    }

    @Override
    public <V> RSet<V> getSet(String name, Codec codec) {
        return new RedissonSet(codec, this.commandExecutor, name, null);
    }

    @Override
    public <K, V> RMap<K, V> getMap(String name) {
        return new RedissonMap(this.commandExecutor, name, null, null, null);
    }

    @Override
    public <K, V> RMap<K, V> getMap(String name, Codec codec) {
        return new RedissonMap(codec, this.commandExecutor, name, null, null, null);
    }

    @Override
    public <V> RScoredSortedSet<V> getScoredSortedSet(String name) {
        return new RedissonScoredSortedSet(this.commandExecutor, name, null);
    }

    @Override
    public <V> RScoredSortedSet<V> getScoredSortedSet(String name, Codec codec) {
        return new RedissonScoredSortedSet(codec, this.commandExecutor, name, null);
    }

    @Override
    public <V> RList<V> getList(String name) {
        return new RedissonList(this.commandExecutor, name, null);
    }

    @Override
    public <V> RList<V> getList(String name, Codec codec) {
        return new RedissonList(codec, this.commandExecutor, name, null);
    }

    @Override
    public <V> RQueue<V> getQueue(String name) {
        return new RedissonQueue(this.commandExecutor, name, null);
    }

    @Override
    public <V> RQueue<V> getQueue(String name, Codec codec) {
        return new RedissonQueue(codec, this.commandExecutor, name, null);
    }

    @Override
    public <V> RDeque<V> getDeque(String name) {
        return new RedissonDeque(this.commandExecutor, name, null);
    }

    @Override
    public <V> RDeque<V> getDeque(String name, Codec codec) {
        return new RedissonDeque(codec, this.commandExecutor, name, null);
    }

    @Override
    public <V> RBlockingQueue<V> getBlockingQueue(String name) {
        return new RedissonBlockingQueue(this.commandExecutor, name, null);
    }

    @Override
    public <V> RBlockingQueue<V> getBlockingQueue(String name, Codec codec) {
        return new RedissonBlockingQueue(codec, this.commandExecutor, name, null);
    }

    @Override
    public <V> RBlockingDeque<V> getBlockingDeque(String name) {
        return new RedissonBlockingDeque(this.commandExecutor, name, null);
    }

    @Override
    public <V> RBlockingDeque<V> getBlockingDeque(String name, Codec codec) {
        return new RedissonBlockingDeque(codec, this.commandExecutor, name, null);
    }

    @Override
    public <V> RGeo<V> getGeo(String name) {
        return new RedissonGeo(this.commandExecutor, name, null);
    }

    @Override
    public <V> RGeo<V> getGeo(String name, Codec codec) {
        return new RedissonGeo(codec, this.commandExecutor, name, null);
    }

    @Override
    public void destroy() {
        PublishSubscribeService subscribeService = this.commandExecutor.getConnectionManager().getSubscribeService();
        this.commandExecutor.get(subscribeService.removeFlushListenerAsync(this.listenerId));
    }
}

