/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.iterator;

import java.util.Map;
import org.redisson.RedissonMap;
import org.redisson.ScanResult;
import org.redisson.client.RedisClient;
import org.redisson.iterator.RedissonBaseMapIterator;

public class RedissonMapIterator<M>
extends RedissonBaseMapIterator<M> {
    private final RedissonMap map;
    private final String pattern;
    private final int count;

    public RedissonMapIterator(RedissonMap map, String pattern, int count) {
        this.map = map;
        this.pattern = pattern;
        this.count = count;
    }

    @Override
    protected Object put(Map.Entry<Object, Object> entry, Object value) {
        return this.map.put(entry.getKey(), value);
    }

    @Override
    protected ScanResult<Map.Entry<Object, Object>> iterator(RedisClient client, String nextIterPos) {
        return this.map.scanIterator(this.map.getRawName(), client, nextIterPos, this.pattern, this.count);
    }

    @Override
    protected void remove(Map.Entry<Object, Object> value) {
        this.map.fastRemove(value.getKey());
    }
}

