/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.navercorp.pinpoint.profiler.cache.Cache;
import com.navercorp.pinpoint.profiler.cache.CaffeineBuilder;
import java.util.concurrent.ConcurrentMap;

public class LRUCache<T>
implements Cache<T, Boolean> {
    private static final Object V = new Object();
    public static final int DEFAULT_CACHE_SIZE = 1024;
    private final ConcurrentMap<T, Object> cache;
    private final com.github.benmanes.caffeine.cache.Cache<T, Object> localCache;

    public LRUCache(int maxCacheSize) {
        Caffeine<Object, Object> cacheBuilder = CaffeineBuilder.newBuilder();
        cacheBuilder.initialCapacity(maxCacheSize);
        cacheBuilder.maximumSize((long)maxCacheSize);
        this.localCache = cacheBuilder.build();
        this.cache = this.localCache.asMap();
    }

    public LRUCache() {
        this(1024);
    }

    @Override
    public Boolean put(T value) {
        Object oldValue = this.cache.putIfAbsent(value, V);
        return oldValue == null;
    }

    public void cleanUp() {
        this.localCache.cleanUp();
    }

    public long getSize() {
        return this.cache.size();
    }
}

