/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.active;

import com.navercorp.pinpoint.common.trace.BaseHistogramSchema;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHandle;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHistogram;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceSnapshot;
import com.navercorp.pinpoint.profiler.context.active.EmptyActiveTraceHistogram;
import com.navercorp.pinpoint.profiler.context.id.LocalTraceRoot;
import com.navercorp.pinpoint.profiler.monitor.metric.response.ResponseTimeCollector;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class EmptyActiveTraceRepository
implements ActiveTraceRepository {
    private final ResponseTimeCollector responseTimeCollector;
    private final ActiveTraceHistogram emptyActiveTraceHistogram = new EmptyActiveTraceHistogram(BaseHistogramSchema.NORMAL_SCHEMA);

    public EmptyActiveTraceRepository(ResponseTimeCollector responseTimeCollector) {
        this.responseTimeCollector = Objects.requireNonNull(responseTimeCollector, "responseTimeCollector");
    }

    @Override
    public ActiveTraceHistogram getActiveTraceHistogram(long timeStamp) {
        return this.emptyActiveTraceHistogram;
    }

    @Override
    public List<Long> getThreadIdList() {
        return null;
    }

    @Override
    public List<ActiveTraceSnapshot> snapshot() {
        return Collections.emptyList();
    }

    @Override
    public ActiveTraceHandle register(LocalTraceRoot traceRoot) {
        return new EmptyActiveTraceHandle(traceRoot.getTraceStartTime());
    }

    private void remove(long startTime, long purgeTime) {
        long responseTime = purgeTime - startTime;
        this.responseTimeCollector.add(responseTime);
    }

    private class EmptyActiveTraceHandle
    implements ActiveTraceHandle {
        private final long startTime;

        public EmptyActiveTraceHandle(long startTime) {
            this.startTime = startTime;
        }

        @Override
        public void purge(long purgeTime) {
            EmptyActiveTraceRepository.this.remove(this.startTime, purgeTime);
        }
    }
}

