/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.grpc.mapper;

import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.grpc.trace.PAcceptEvent;
import com.navercorp.pinpoint.grpc.trace.PAnnotation;
import com.navercorp.pinpoint.grpc.trace.PLocalAsyncId;
import com.navercorp.pinpoint.grpc.trace.PMessageEvent;
import com.navercorp.pinpoint.grpc.trace.PNextEvent;
import com.navercorp.pinpoint.grpc.trace.PParentInfo;
import com.navercorp.pinpoint.grpc.trace.PSpan;
import com.navercorp.pinpoint.grpc.trace.PSpanChunk;
import com.navercorp.pinpoint.grpc.trace.PSpanEvent;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.AsyncId;
import com.navercorp.pinpoint.profiler.context.AsyncSpanChunk;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanChunk;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.grpc.config.SpanUriGetter;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.AnnotationValueMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.MapperUtils;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.SpanMessageMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.TraceIdMapStructUtils;
import com.navercorp.pinpoint.profiler.context.id.Shared;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;

@Singleton
@Named
public class SpanMessageMapperImpl
implements SpanMessageMapper {
    private final AnnotationValueMapper annotationValueMapper;
    private final SpanUriGetter spanUriGetter;

    @Inject
    public SpanMessageMapperImpl(AnnotationValueMapper annotationValueMapper, SpanUriGetter spanUriGetter) {
        this.annotationValueMapper = annotationValueMapper;
        this.spanUriGetter = spanUriGetter;
    }

    @Override
    public void map(Span span, short applicationServiceType, PSpan.Builder builder) {
        if (span == null) {
            return;
        }
        if (span != null) {
            TraceId traceId = this.spanTraceRootTraceId(span);
            if (traceId != null) {
                builder.setTransactionId(TraceIdMapStructUtils.newTransactionId(traceId));
            }
            builder.setSpanId(this.spanTraceRootTraceIdSpanId(span));
            builder.setParentSpanId(this.spanTraceRootTraceIdParentSpanId(span));
            builder.setElapsed(span.getElapsedTime());
            if (span != null) {
                builder.setAcceptEvent(this.toAcceptEvent(span));
            }
            builder.setFlag((int)this.spanTraceRootTraceIdFlags(span));
            builder.setErr(this.spanTraceRootSharedErrorCode(span));
            if (span.getExceptionInfo() != null) {
                builder.setExceptionInfo(this.annotationValueMapper.map(span.getExceptionInfo()));
            }
            builder.setLoggingTransactionInfo((int)this.spanTraceRootSharedLoggingInfo(span));
            if (span.getAnnotations() != null) {
                for (Annotation annotation : span.getAnnotations()) {
                    builder.addAnnotation(this.map(annotation));
                }
            }
            if (span.getSpanEventList() != null) {
                for (SpanEvent spanEvent : span.getSpanEventList()) {
                    builder.addSpanEvent(this.map(spanEvent));
                }
            }
            builder.setStartTime(span.getStartTime());
            builder.setApiId(span.getApiId());
            builder.setServiceType((int)span.getServiceType());
        }
        builder.setVersion(this.spanVersion(applicationServiceType));
        builder.setApplicationServiceType((int)applicationServiceType);
    }

    @Override
    public void toPSpanChunk(SpanChunk spanChunk, short applicationServiceType, PSpanChunk.Builder builder) {
        if (spanChunk == null) {
            return;
        }
        if (spanChunk != null) {
            TraceId traceId = this.spanChunkTraceRootTraceId(spanChunk);
            if (traceId != null) {
                builder.setTransactionId(TraceIdMapStructUtils.newTransactionId(traceId));
            }
            builder.setSpanId(this.spanChunkTraceRootTraceIdSpanId(spanChunk));
            String endPoint = this.spanChunkTraceRootSharedEndPoint(spanChunk);
            if (endPoint != null) {
                builder.setEndPoint(endPoint);
            }
            if (spanChunk.getSpanEventList() != null) {
                for (SpanEvent spanChunkSpanEventList : spanChunk.getSpanEventList()) {
                    builder.addSpanEvent(this.map(spanChunkSpanEventList));
                }
            }
        }
        builder.setVersion(this.spanVersion(applicationServiceType));
        builder.setApplicationServiceType((int)applicationServiceType);
    }

    @Override
    public void toAsyncSpanChunk(AsyncSpanChunk asyncSpanChunk, short applicationServiceType, PSpanChunk.Builder builder) {
        if (asyncSpanChunk == null) {
            return;
        }
        if (asyncSpanChunk != null) {
            TraceId traceId;
            if (asyncSpanChunk.getLocalAsyncId() != null) {
                builder.setLocalAsyncId(this.map(asyncSpanChunk.getLocalAsyncId()));
            }
            if ((traceId = this.asyncSpanChunkTraceRootTraceId(asyncSpanChunk)) != null) {
                builder.setTransactionId(TraceIdMapStructUtils.newTransactionId(traceId));
            }
            builder.setSpanId(this.asyncSpanChunkTraceRootTraceIdSpanId(asyncSpanChunk));
            String endPoint = this.asyncSpanChunkTraceRootSharedEndPoint(asyncSpanChunk);
            if (endPoint != null) {
                builder.setEndPoint(endPoint);
            }
            if (asyncSpanChunk.getSpanEventList() != null) {
                for (SpanEvent spanChunkSpanEventList : asyncSpanChunk.getSpanEventList()) {
                    builder.addSpanEvent(this.map(spanChunkSpanEventList));
                }
            }
        }
        builder.setVersion(this.spanVersion(applicationServiceType));
        builder.setApplicationServiceType((int)applicationServiceType);
    }

    @Override
    public PLocalAsyncId map(LocalAsyncId localAsyncId) {
        if (localAsyncId == null) {
            return null;
        }
        PLocalAsyncId.Builder pLocalAsyncId = PLocalAsyncId.newBuilder();
        pLocalAsyncId.setAsyncId(localAsyncId.getAsyncId());
        pLocalAsyncId.setSequence(localAsyncId.getSequence());
        return pLocalAsyncId.build();
    }

    @Override
    public PSpanEvent map(SpanEvent spanEvent) {
        if (spanEvent == null) {
            return null;
        }
        PSpanEvent.Builder pSpanEvent = PSpanEvent.newBuilder();
        pSpanEvent.setEndElapsed(spanEvent.getElapsedTime());
        if (MapperUtils.isNotMinusOne(spanEvent.getDepth())) {
            pSpanEvent.setDepth(spanEvent.getDepth());
        }
        if (spanEvent != null) {
            pSpanEvent.setNextEvent(this.mapNextEvent(spanEvent));
        }
        pSpanEvent.setAsyncEvent(this.spanEventAsyncIdObjectAsyncId(spanEvent));
        if (spanEvent.getAnnotations() != null) {
            for (Annotation<?> annotation : spanEvent.getAnnotations()) {
                pSpanEvent.addAnnotation(this.map(annotation));
            }
        }
        pSpanEvent.setSequence(spanEvent.getSequence());
        pSpanEvent.setServiceType((int)spanEvent.getServiceType());
        pSpanEvent.setApiId(spanEvent.getApiId());
        if (spanEvent.getExceptionInfo() != null) {
            pSpanEvent.setExceptionInfo(this.annotationValueMapper.map(spanEvent.getExceptionInfo()));
        }
        return pSpanEvent.build();
    }

    @Override
    public PNextEvent mapNextEvent(SpanEvent spanEvent) {
        if (spanEvent == null) {
            return null;
        }
        PNextEvent.Builder pNextEvent = PNextEvent.newBuilder();
        if (spanEvent != null) {
            pNextEvent.setMessageEvent(this.mapMessageEvent(spanEvent));
        }
        return pNextEvent.build();
    }

    @Override
    public PMessageEvent mapMessageEvent(SpanEvent spanEvent) {
        if (spanEvent == null) {
            return null;
        }
        PMessageEvent.Builder pMessageEvent = PMessageEvent.newBuilder();
        pMessageEvent.setNextSpanId(spanEvent.getNextSpanId());
        if (spanEvent.getEndPoint() != null) {
            pMessageEvent.setEndPoint(spanEvent.getEndPoint());
        }
        if (spanEvent.getDestinationId() != null) {
            pMessageEvent.setDestinationId(spanEvent.getDestinationId());
        }
        return pMessageEvent.build();
    }

    @Override
    public PAnnotation map(Annotation<?> annotation) {
        if (annotation == null) {
            return null;
        }
        PAnnotation.Builder pAnnotation = PAnnotation.newBuilder();
        if (annotation != null) {
            pAnnotation.setValue(this.annotationValueMapper.map(annotation));
        }
        pAnnotation.setKey(annotation.getKey());
        return pAnnotation.build();
    }

    @Override
    public PAcceptEvent toAcceptEvent(Span span) {
        String endPoint;
        if (span == null) {
            return null;
        }
        PAcceptEvent.Builder pAcceptEvent = PAcceptEvent.newBuilder();
        if (span.getRemoteAddr() != null) {
            pAcceptEvent.setRemoteAddr(span.getRemoteAddr());
        } else {
            pAcceptEvent.setRemoteAddr("UNKNOWN");
        }
        Shared shared = this.spanTraceRootShared(span);
        if (shared != null) {
            pAcceptEvent.setRpc(this.spanUriGetter.getNonEmptyCollectedUri(shared));
        }
        if ((endPoint = this.spanTraceRootSharedEndPoint(span)) != null) {
            pAcceptEvent.setEndPoint(endPoint);
        } else {
            pAcceptEvent.setEndPoint("UNKNOWN");
        }
        if (span != null) {
            pAcceptEvent.setParentInfo(this.toParentInfo(span));
        }
        return pAcceptEvent.build();
    }

    @Override
    public PParentInfo toParentInfo(Span span) {
        if (span == null) {
            return null;
        }
        PParentInfo.Builder pParentInfo = PParentInfo.newBuilder();
        if (MapperUtils.isNotZero(span.getParentApplicationType())) {
            pParentInfo.setParentApplicationType((int)span.getParentApplicationType());
        }
        if (span.getParentApplicationName() != null) {
            pParentInfo.setParentApplicationName(span.getParentApplicationName());
        }
        if (span.getAcceptorHost() != null) {
            pParentInfo.setAcceptorHost(span.getAcceptorHost());
        }
        return pParentInfo.build();
    }

    private TraceId spanTraceRootTraceId(Span span) {
        if (span == null) {
            return null;
        }
        TraceRoot traceRoot = span.getTraceRoot();
        if (traceRoot == null) {
            return null;
        }
        TraceId traceId = traceRoot.getTraceId();
        if (traceId == null) {
            return null;
        }
        return traceId;
    }

    private long spanTraceRootTraceIdSpanId(Span span) {
        if (span == null) {
            return 0L;
        }
        TraceRoot traceRoot = span.getTraceRoot();
        if (traceRoot == null) {
            return 0L;
        }
        TraceId traceId = traceRoot.getTraceId();
        if (traceId == null) {
            return 0L;
        }
        long spanId = traceId.getSpanId();
        return spanId;
    }

    private long spanTraceRootTraceIdParentSpanId(Span span) {
        if (span == null) {
            return 0L;
        }
        TraceRoot traceRoot = span.getTraceRoot();
        if (traceRoot == null) {
            return 0L;
        }
        TraceId traceId = traceRoot.getTraceId();
        if (traceId == null) {
            return 0L;
        }
        long parentSpanId = traceId.getParentSpanId();
        return parentSpanId;
    }

    private short spanTraceRootTraceIdFlags(Span span) {
        if (span == null) {
            return 0;
        }
        TraceRoot traceRoot = span.getTraceRoot();
        if (traceRoot == null) {
            return 0;
        }
        TraceId traceId = traceRoot.getTraceId();
        if (traceId == null) {
            return 0;
        }
        short flags = traceId.getFlags();
        return flags;
    }

    private int spanTraceRootSharedErrorCode(Span span) {
        if (span == null) {
            return 0;
        }
        TraceRoot traceRoot = span.getTraceRoot();
        if (traceRoot == null) {
            return 0;
        }
        Shared shared = traceRoot.getShared();
        if (shared == null) {
            return 0;
        }
        int errorCode = shared.getErrorCode();
        return errorCode;
    }

    private byte spanTraceRootSharedLoggingInfo(Span span) {
        if (span == null) {
            return 0;
        }
        TraceRoot traceRoot = span.getTraceRoot();
        if (traceRoot == null) {
            return 0;
        }
        Shared shared = traceRoot.getShared();
        if (shared == null) {
            return 0;
        }
        byte loggingInfo = shared.getLoggingInfo();
        return loggingInfo;
    }

    private TraceId spanChunkTraceRootTraceId(SpanChunk spanChunk) {
        if (spanChunk == null) {
            return null;
        }
        TraceRoot traceRoot = spanChunk.getTraceRoot();
        if (traceRoot == null) {
            return null;
        }
        TraceId traceId = traceRoot.getTraceId();
        if (traceId == null) {
            return null;
        }
        return traceId;
    }

    private long spanChunkTraceRootTraceIdSpanId(SpanChunk spanChunk) {
        if (spanChunk == null) {
            return 0L;
        }
        TraceRoot traceRoot = spanChunk.getTraceRoot();
        if (traceRoot == null) {
            return 0L;
        }
        TraceId traceId = traceRoot.getTraceId();
        if (traceId == null) {
            return 0L;
        }
        long spanId = traceId.getSpanId();
        return spanId;
    }

    private String spanChunkTraceRootSharedEndPoint(SpanChunk spanChunk) {
        if (spanChunk == null) {
            return null;
        }
        TraceRoot traceRoot = spanChunk.getTraceRoot();
        if (traceRoot == null) {
            return null;
        }
        Shared shared = traceRoot.getShared();
        if (shared == null) {
            return null;
        }
        String endPoint = shared.getEndPoint();
        if (endPoint == null) {
            return null;
        }
        return endPoint;
    }

    private TraceId asyncSpanChunkTraceRootTraceId(AsyncSpanChunk asyncSpanChunk) {
        if (asyncSpanChunk == null) {
            return null;
        }
        TraceRoot traceRoot = asyncSpanChunk.getTraceRoot();
        if (traceRoot == null) {
            return null;
        }
        TraceId traceId = traceRoot.getTraceId();
        if (traceId == null) {
            return null;
        }
        return traceId;
    }

    private long asyncSpanChunkTraceRootTraceIdSpanId(AsyncSpanChunk asyncSpanChunk) {
        if (asyncSpanChunk == null) {
            return 0L;
        }
        TraceRoot traceRoot = asyncSpanChunk.getTraceRoot();
        if (traceRoot == null) {
            return 0L;
        }
        TraceId traceId = traceRoot.getTraceId();
        if (traceId == null) {
            return 0L;
        }
        long spanId = traceId.getSpanId();
        return spanId;
    }

    private String asyncSpanChunkTraceRootSharedEndPoint(AsyncSpanChunk asyncSpanChunk) {
        if (asyncSpanChunk == null) {
            return null;
        }
        TraceRoot traceRoot = asyncSpanChunk.getTraceRoot();
        if (traceRoot == null) {
            return null;
        }
        Shared shared = traceRoot.getShared();
        if (shared == null) {
            return null;
        }
        String endPoint = shared.getEndPoint();
        if (endPoint == null) {
            return null;
        }
        return endPoint;
    }

    private int spanEventAsyncIdObjectAsyncId(SpanEvent spanEvent) {
        if (spanEvent == null) {
            return 0;
        }
        AsyncId asyncIdObject = spanEvent.getAsyncIdObject();
        if (asyncIdObject == null) {
            return 0;
        }
        int asyncId = asyncIdObject.getAsyncId();
        return asyncId;
    }

    private Shared spanTraceRootShared(Span span) {
        if (span == null) {
            return null;
        }
        TraceRoot traceRoot = span.getTraceRoot();
        if (traceRoot == null) {
            return null;
        }
        Shared shared = traceRoot.getShared();
        if (shared == null) {
            return null;
        }
        return shared;
    }

    private String spanTraceRootSharedEndPoint(Span span) {
        if (span == null) {
            return null;
        }
        TraceRoot traceRoot = span.getTraceRoot();
        if (traceRoot == null) {
            return null;
        }
        Shared shared = traceRoot.getShared();
        if (shared == null) {
            return null;
        }
        String endPoint = shared.getEndPoint();
        if (endPoint == null) {
            return null;
        }
        return endPoint;
    }
}

