/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.monitor.metric;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.IdValidateUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomMetricIdGenerator {
    static final int NOT_REGISTERED = -1;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final Object lockObject = new Object();
    private final int limitIdNumber;
    private final Map<String, Integer> metricNameToIdMap = new HashMap<String, Integer>();
    private int currentId = 0;

    CustomMetricIdGenerator(int limitIdNumber) {
        Assert.isTrue((limitIdNumber > 0 ? 1 : 0) != 0, (String)"'limitIdNumber' must be >= 0");
        this.limitIdNumber = limitIdNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int create(String metricName) {
        if (!this.checkValidCustomMetricName(metricName)) {
            this.logger.warn("Failed to create MetricId. metricName:{}", (Object)metricName);
            return -1;
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (this.currentId >= this.limitIdNumber) {
                return -1;
            }
            boolean contains = this.metricNameToIdMap.containsKey(metricName);
            if (contains) {
                return -1;
            }
            ++this.currentId;
            this.metricNameToIdMap.put(metricName, this.currentId);
            return this.currentId;
        }
    }

    private boolean checkValidCustomMetricName(String customMetricName) {
        try {
            String[] split = customMetricName.split("/", 3);
            if (split.length != 3) {
                throw new IllegalArgumentException("customMetricName must consist of {GroupName}/{MetricName}/LabelName}");
            }
            for (String eachName : split) {
                if (IdValidateUtils.validateId((String)eachName, (int)64)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logger.warn("Inserted customMetricName({}) is not valid. cause:{}", (Object)customMetricName, (Object)e.getMessage(), (Object)e);
            return false;
        }
    }
}

