/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.loader.service.ServiceTypeRegistryService;
import com.navercorp.pinpoint.profiler.instrument.config.InstrumentConfig;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfiguredApplicationTypeProvider
implements Provider<ServiceType> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final String applicationTypeString;
    private final ServiceTypeRegistryService serviceTypeRegistryService;

    @Inject
    public ConfiguredApplicationTypeProvider(InstrumentConfig instrumentConfig, ServiceTypeRegistryService serviceTypeRegistryService) {
        Objects.requireNonNull(instrumentConfig, "instrumentConfig");
        this.serviceTypeRegistryService = Objects.requireNonNull(serviceTypeRegistryService, "serviceTypeRegistryService");
        this.applicationTypeString = instrumentConfig.getApplicationServerType();
    }

    public ServiceType get() {
        ServiceType applicationType = this.serviceTypeRegistryService.findServiceTypeByName(this.applicationTypeString);
        if (applicationType == null) {
            return ServiceType.UNDEFINED;
        }
        if (ServiceType.UNDEFINED.equals(applicationType)) {
            return ServiceType.UNDEFINED;
        }
        if (applicationType.isWas()) {
            return applicationType;
        }
        this.logger.warn("Invalid application type configured : {}, defaulting to {}", (Object)applicationType, (Object)ServiceType.UNDEFINED);
        return ServiceType.UNDEFINED;
    }
}

