/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.profiler.instrument.ASMEngine;
import com.navercorp.pinpoint.profiler.instrument.DefaultEngineComponent;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.instrument.ScopeFactory;
import com.navercorp.pinpoint.profiler.instrument.config.InstrumentConfig;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorDefinitionFactory;
import com.navercorp.pinpoint.profiler.interceptor.registry.InterceptorRegistryBinder;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import com.navercorp.pinpoint.profiler.objectfactory.ObjectBinderFactory;
import java.lang.instrument.Instrumentation;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InstrumentEngineProvider
implements Provider<InstrumentEngine> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final InstrumentConfig instrumentConfig;
    private final InterceptorRegistryBinder interceptorRegistryBinder;
    private final Provider<ApiMetaDataService> apiMetaDataServiceProvider;
    private final ObjectBinderFactory objectBinderFactory;
    private final Instrumentation instrumentation;

    @Inject
    public InstrumentEngineProvider(InstrumentConfig instrumentConfig, Instrumentation instrumentation, ObjectBinderFactory objectBinderFactory, InterceptorRegistryBinder interceptorRegistryBinder, Provider<ApiMetaDataService> apiMetaDataServiceProvider) {
        this.instrumentConfig = Objects.requireNonNull(instrumentConfig, "instrumentConfig");
        this.instrumentation = Objects.requireNonNull(instrumentation, "instrumentation");
        this.objectBinderFactory = Objects.requireNonNull(objectBinderFactory, "objectBinderFactory");
        this.interceptorRegistryBinder = Objects.requireNonNull(interceptorRegistryBinder, "interceptorRegistryBinder");
        this.apiMetaDataServiceProvider = Objects.requireNonNull(apiMetaDataServiceProvider, "apiMetaDataServiceProvider");
    }

    public InstrumentEngine get() {
        String instrumentEngine = this.instrumentConfig.getProfileInstrumentEngine().toUpperCase();
        if ("ASM".equals(instrumentEngine)) {
            this.logger.info("ASM InstrumentEngine");
            InterceptorDefinitionFactory interceptorDefinitionFactory = new InterceptorDefinitionFactory();
            ScopeFactory scopeFactory = new ScopeFactory();
            DefaultEngineComponent engineComponent = new DefaultEngineComponent(this.objectBinderFactory, this.interceptorRegistryBinder, interceptorDefinitionFactory, this.apiMetaDataServiceProvider, scopeFactory);
            return new ASMEngine(this.instrumentation, engineComponent);
        }
        this.logger.warn("Unknown InstrumentEngine:{}", (Object)instrumentEngine);
        throw new IllegalArgumentException("Unknown InstrumentEngine:" + instrumentEngine);
    }
}

