/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.interceptor.Interceptor;
import com.navercorp.pinpoint.profiler.instrument.ScopeInfo;
import com.navercorp.pinpoint.profiler.instrument.classloading.InterceptorDefineClassHelper;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorHolder;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorLazyLoadingSupplier;
import com.navercorp.pinpoint.profiler.instrument.interceptor.InterceptorSupplier;
import com.navercorp.pinpoint.profiler.interceptor.factory.InterceptorFactory;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Supplier;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ASMInterceptorHolder {
    private static final String INTERCEPTOR_HOLDER_CLASS = "com/navercorp/pinpoint/profiler/instrument/interceptor/InterceptorHolder.class";
    private static final String INTERCEPTOR_HOLDER_INNER_CLASS = "com/navercorp/pinpoint/profiler/instrument/interceptor/InterceptorHolder$LazyLoading.class";
    private final String className;
    private final String innerClassName;

    public static String getInterceptorHolderClassName(int interceptorId) {
        return InterceptorHolder.class.getName() + "$$" + interceptorId;
    }

    public static void create(int interceptorId, ClassLoader classLoader, InterceptorFactory interceptorFactory, Class<? extends Interceptor> interceptorClass, Object[] providedArguments, ScopeInfo scopeInfo, MethodDescriptor methodDescriptor) throws InstrumentException {
        Builder builder = new Builder(interceptorId);
        builder.interceptorFactory(classLoader, interceptorFactory, interceptorClass, providedArguments, scopeInfo, methodDescriptor);
        builder.build();
    }

    public static void create(int interceptorId, ClassLoader classLoader, Interceptor interceptor) throws InstrumentException {
        Builder builder = new Builder(interceptorId);
        builder.interceptor(classLoader, interceptor);
        builder.build();
    }

    public ASMInterceptorHolder(int interceptorId) {
        this.className = ASMInterceptorHolder.getInterceptorHolderClassName(interceptorId);
        this.innerClassName = this.className + "$LazyLoading";
    }

    public Class<? extends Interceptor> loadInterceptorClass(ClassLoader classLoader) throws InstrumentException {
        if (classLoader == null) {
            throw new InstrumentException("classLoader must not be null");
        }
        try {
            Class<?> clazz = classLoader.loadClass(this.className);
            if (clazz == null) {
                throw new InstrumentException("not found interceptorHolderClass, className=" + this.className);
            }
            Method method = clazz.getDeclaredMethod("get", new Class[0]);
            Object o = method.invoke(null, new Object[0]);
            if (o instanceof Interceptor) {
                return o.getClass();
            }
            throw new InstrumentException("not found interceptor, className=" + this.className);
        }
        catch (ClassNotFoundException e) {
            throw new InstrumentException("not found class, className=" + this.className, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new InstrumentException("invocation fail, className=" + this.className, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new InstrumentException("not found 'get' method, className=" + this.className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InstrumentException("access fail, className=" + this.className, (Throwable)e);
        }
    }

    public void init(Class<?> interceptorHolderClass, InterceptorFactory factory, Class<? extends Interceptor> interceptorClass, Object[] providedArguments, ScopeInfo scopeInfo, MethodDescriptor methodDescriptor) throws InstrumentException {
        this.init(interceptorHolderClass, new InterceptorLazyLoadingSupplier(factory, interceptorClass, providedArguments, scopeInfo, methodDescriptor));
    }

    public void init(Class<?> interceptorHolderClass, Interceptor interceptor) throws InstrumentException {
        this.init(interceptorHolderClass, new InterceptorSupplier(interceptor));
    }

    private void init(Class<?> interceptorHolderClass, Supplier<Interceptor> supplier) throws InstrumentException {
        try {
            Method method = interceptorHolderClass.getDeclaredMethod("set", Supplier.class);
            method.invoke(null, supplier);
        }
        catch (NoSuchMethodException e) {
            throw new InstrumentException("not found 'set' method, className=" + interceptorHolderClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InstrumentException("access fail, className=" + interceptorHolderClass.getName(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new InstrumentException("invocation fail, className=" + interceptorHolderClass.getName(), (Throwable)e);
        }
    }

    public Class<?> defineClass(ClassLoader classLoader) throws InstrumentException {
        try {
            byte[] mainClassBytes = this.toMainClassByteArray();
            Class<?> mainClass = InterceptorDefineClassHelper.defineClass(classLoader, this.className, mainClassBytes);
            byte[] innerClassByte = this.toInnerClassByteArray();
            InterceptorDefineClassHelper.defineClass(classLoader, this.innerClassName, innerClassByte);
            return mainClass;
        }
        catch (Exception e) {
            throw new InstrumentException("defineClass fail", (Throwable)e);
        }
    }

    byte[] toMainClassByteArray() throws InstrumentException {
        try {
            ClassNode classNode = this.readClass(INTERCEPTOR_HOLDER_CLASS);
            ClassWriter classWriter = new ClassWriter(2);
            RenameClassAdapter renameClassAdapter = new RenameClassAdapter((ClassVisitor)classWriter, this.className);
            classNode.accept((ClassVisitor)renameClassAdapter);
            return classWriter.toByteArray();
        }
        catch (IOException e) {
            throw new InstrumentException("ClassReader fail, classFile=com/navercorp/pinpoint/profiler/instrument/interceptor/InterceptorHolder.class", (Throwable)e);
        }
    }

    byte[] toInnerClassByteArray() throws InstrumentException {
        try {
            ClassNode classNode = this.readClass(INTERCEPTOR_HOLDER_INNER_CLASS);
            ClassWriter classWriter = new ClassWriter(2);
            RenameInnerClassAdapter renameClassAdapter = new RenameInnerClassAdapter((ClassVisitor)classWriter, this.className);
            classNode.accept((ClassVisitor)renameClassAdapter);
            return classWriter.toByteArray();
        }
        catch (IOException e) {
            throw new InstrumentException("ClassReader fail, classFile=com/navercorp/pinpoint/profiler/instrument/interceptor/InterceptorHolder$LazyLoading.class", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassNode readClass(String classFileName) throws IOException {
        ClassLoader classLoader = ASMInterceptorHolder.class.getClassLoader();
        InputStream inputStram = classLoader.getResourceAsStream(classFileName);
        if (inputStram == null) {
            throw new IOException("not found class " + classFileName);
        }
        try {
            ClassReader classReader = new ClassReader(inputStram);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            ClassNode classNode2 = classNode;
            return classNode2;
        }
        finally {
            inputStram.close();
        }
    }

    static class RenameInnerClassAdapter
    extends ClassVisitor {
        private final String newInternalName;

        public RenameInnerClassAdapter(ClassVisitor classVisitor, String name) {
            super(589824, classVisitor);
            this.newInternalName = JavaAssistUtils.javaNameToJvmName(name);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            int innerNameStartPosition = name.indexOf(36);
            if (innerNameStartPosition != -1) {
                String innerName = name.substring(innerNameStartPosition);
                super.visit(version, access, this.newInternalName + innerName, signature, superName, interfaces);
            } else {
                super.visit(version, access, this.newInternalName, signature, superName, interfaces);
            }
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            super.visitInnerClass(this.newInternalName + "$" + innerName, this.newInternalName, innerName, access);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (name.equals("<init>")) {
                return new MethodVisitor(this.api, super.visitMethod(access, name, descriptor, signature, exceptions)){

                    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                        if (name.equals("this")) {
                            int innerNameStartPosition = descriptor.indexOf(36);
                            if (innerNameStartPosition != -1) {
                                String innerName = descriptor.substring(innerNameStartPosition);
                                String newDescriptor = "L" + newInternalName + innerName;
                                super.visitLocalVariable(name, newDescriptor, signature, start, end, index);
                            } else {
                                super.visitLocalVariable(name, descriptor, signature, start, end, index);
                            }
                        } else {
                            super.visitLocalVariable(name, descriptor, signature, start, end, index);
                        }
                    }
                };
            }
            if (name.equals("<clinit>")) {
                return new MethodVisitor(this.api, super.visitMethod(access, name, descriptor, signature, exceptions)){

                    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                        if (name.equals("access$000")) {
                            super.visitMethodInsn(opcode, newInternalName, name, descriptor, isInterface);
                        } else {
                            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                        }
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                        int innerNameStartPosition = owner.indexOf(36);
                        if (innerNameStartPosition != -1) {
                            String innerName = owner.substring(innerNameStartPosition);
                            super.visitFieldInsn(opcode, newInternalName + innerName, name, descriptor);
                        } else {
                            super.visitFieldInsn(opcode, newInternalName, name, descriptor);
                        }
                    }
                };
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
    }

    static class RenameClassAdapter
    extends ClassVisitor {
        private final String newInternalName;

        public RenameClassAdapter(ClassVisitor classVisitor, String name) {
            super(589824, classVisitor);
            this.newInternalName = JavaAssistUtils.javaNameToJvmName(name);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, this.newInternalName, signature, superName, interfaces);
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            super.visitInnerClass(this.newInternalName + "$" + innerName, this.newInternalName, innerName, access);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (name.equals("<init>")) {
                return new MethodVisitor(this.api, super.visitMethod(access, name, descriptor, signature, exceptions)){

                    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                        if (name.equals("this")) {
                            String newDescriptor = "L" + newInternalName + ";";
                            super.visitLocalVariable(name, newDescriptor, signature, start, end, index);
                        } else {
                            super.visitLocalVariable(name, descriptor, signature, start, end, index);
                        }
                    }
                };
            }
            if (name.equals("get")) {
                return new MethodVisitor(this.api, super.visitMethod(access, name, descriptor, signature, exceptions)){

                    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                        int innerNameStartPosition = owner.indexOf(36);
                        if (innerNameStartPosition != -1) {
                            String innerName = owner.substring(innerNameStartPosition);
                            super.visitFieldInsn(opcode, newInternalName + innerName, name, descriptor);
                        } else {
                            super.visitFieldInsn(opcode, newInternalName, name, descriptor);
                        }
                    }
                };
            }
            if (name.equals("set")) {
                return new MethodVisitor(this.api, super.visitMethod(access, name, descriptor, signature, exceptions)){

                    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                        super.visitFieldInsn(opcode, newInternalName, name, descriptor);
                    }
                };
            }
            if (name.equals("access$000")) {
                return new MethodVisitor(this.api, super.visitMethod(access, name, descriptor, signature, exceptions)){

                    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                        super.visitFieldInsn(opcode, newInternalName, name, descriptor);
                    }
                };
            }
            return super.visitMethod(access, name, descriptor, signature, exceptions);
        }
    }

    static class Builder {
        private final int interceptorId;
        private ClassLoader classLoader;
        private InterceptorFactory interceptorFactory;
        private Class<? extends Interceptor> interceptorClass;
        private Object[] providedArguments;
        private ScopeInfo scopeInfo;
        private MethodDescriptor methodDescriptor;
        private Interceptor interceptor;

        public Builder(int interceptorId) {
            this.interceptorId = interceptorId;
        }

        public Builder interceptorFactory(ClassLoader classLoader, InterceptorFactory interceptorFactory, Class<? extends Interceptor> interceptorClass, Object[] providedArguments, ScopeInfo scopeInfo, MethodDescriptor methodDescriptor) {
            this.classLoader = Objects.requireNonNull(classLoader, "classLoader");
            this.interceptorFactory = Objects.requireNonNull(interceptorFactory, "interceptorFactory");
            this.interceptorClass = Objects.requireNonNull(interceptorClass, "interceptorClass");
            this.providedArguments = providedArguments;
            this.scopeInfo = scopeInfo;
            this.methodDescriptor = methodDescriptor;
            return this;
        }

        public Builder interceptor(ClassLoader classLoader, Interceptor interceptor) {
            this.classLoader = Objects.requireNonNull(classLoader, "classLoader");
            this.interceptor = Objects.requireNonNull(interceptor, "interceptor");
            return this;
        }

        public ASMInterceptorHolder build() throws InstrumentException {
            ASMInterceptorHolder holder = new ASMInterceptorHolder(this.interceptorId);
            Class<?> clazz = holder.defineClass(this.classLoader);
            if (this.interceptor != null) {
                holder.init(clazz, this.interceptor);
            } else if (this.interceptorFactory != null) {
                holder.init(clazz, this.interceptorFactory, this.interceptorClass, this.providedArguments, this.scopeInfo, this.methodDescriptor);
            } else {
                throw new InstrumentException("either interceptor or interceptorFactory must be present.");
            }
            return holder;
        }
    }
}

