/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.http.body.client;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.eventmesh.common.protocol.http.body.Body;

public class HeartbeatResponseBody
extends Body {
    private Integer retCode;
    private String retMsg;
    private long resTime = System.currentTimeMillis();

    public Integer getRetCode() {
        return this.retCode;
    }

    public void setRetCode(Integer retCode) {
        this.retCode = retCode;
    }

    public String getRetMsg() {
        return this.retMsg;
    }

    public void setRetMsg(String retMsg) {
        this.retMsg = retMsg;
    }

    public long getResTime() {
        return this.resTime;
    }

    public void setResTime(long resTime) {
        this.resTime = resTime;
    }

    public static HeartbeatResponseBody buildBody(Integer retCode, String retMsg) {
        HeartbeatResponseBody heartbeatResponseBody = new HeartbeatResponseBody();
        heartbeatResponseBody.setRetMsg(retMsg);
        heartbeatResponseBody.setResTime(System.currentTimeMillis());
        heartbeatResponseBody.setRetCode(retCode);
        return heartbeatResponseBody;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("heartbeatResponseBody={").append("retCode=").append(this.retCode).append(",").append("retMsg=").append(this.retMsg).append(",").append("resTime=").append(DateFormatUtils.format((long)this.resTime, (String)"yyyy-MM-dd HH:mm:ss.SSS")).append("}");
        return sb.toString();
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("retCode", this.retCode);
        map.put("retMsg", this.retMsg);
        map.put("resTime", this.resTime);
        return map;
    }
}

