/*
 * Decompiled with CFR 0.152.
 */
package com.lark.oapi.service.approval.v4;

import com.lark.oapi.core.Config;
import com.lark.oapi.core.Transport;
import com.lark.oapi.core.request.RequestOptions;
import com.lark.oapi.core.response.RawResponse;
import com.lark.oapi.core.token.AccessTokenType;
import com.lark.oapi.core.utils.Jsons;
import com.lark.oapi.core.utils.Sets;
import com.lark.oapi.core.utils.UnmarshalRespUtil;
import com.lark.oapi.event.IEventHandler;
import com.lark.oapi.service.approval.v4.model.AddSignInstanceReq;
import com.lark.oapi.service.approval.v4.model.AddSignInstanceResp;
import com.lark.oapi.service.approval.v4.model.ApproveTaskReq;
import com.lark.oapi.service.approval.v4.model.ApproveTaskResp;
import com.lark.oapi.service.approval.v4.model.CancelInstanceReq;
import com.lark.oapi.service.approval.v4.model.CancelInstanceResp;
import com.lark.oapi.service.approval.v4.model.CcInstanceReq;
import com.lark.oapi.service.approval.v4.model.CcInstanceResp;
import com.lark.oapi.service.approval.v4.model.CheckExternalInstanceReq;
import com.lark.oapi.service.approval.v4.model.CheckExternalInstanceResp;
import com.lark.oapi.service.approval.v4.model.CreateApprovalReq;
import com.lark.oapi.service.approval.v4.model.CreateApprovalResp;
import com.lark.oapi.service.approval.v4.model.CreateExternalApprovalReq;
import com.lark.oapi.service.approval.v4.model.CreateExternalApprovalResp;
import com.lark.oapi.service.approval.v4.model.CreateExternalInstanceReq;
import com.lark.oapi.service.approval.v4.model.CreateExternalInstanceResp;
import com.lark.oapi.service.approval.v4.model.CreateInstanceCommentReq;
import com.lark.oapi.service.approval.v4.model.CreateInstanceCommentResp;
import com.lark.oapi.service.approval.v4.model.CreateInstanceReq;
import com.lark.oapi.service.approval.v4.model.CreateInstanceResp;
import com.lark.oapi.service.approval.v4.model.DeleteInstanceCommentReq;
import com.lark.oapi.service.approval.v4.model.DeleteInstanceCommentResp;
import com.lark.oapi.service.approval.v4.model.GetApprovalReq;
import com.lark.oapi.service.approval.v4.model.GetApprovalResp;
import com.lark.oapi.service.approval.v4.model.GetExternalApprovalReq;
import com.lark.oapi.service.approval.v4.model.GetExternalApprovalResp;
import com.lark.oapi.service.approval.v4.model.GetInstanceReq;
import com.lark.oapi.service.approval.v4.model.GetInstanceResp;
import com.lark.oapi.service.approval.v4.model.ListExternalTaskReq;
import com.lark.oapi.service.approval.v4.model.ListExternalTaskResp;
import com.lark.oapi.service.approval.v4.model.ListInstanceCommentReq;
import com.lark.oapi.service.approval.v4.model.ListInstanceCommentResp;
import com.lark.oapi.service.approval.v4.model.ListInstanceReq;
import com.lark.oapi.service.approval.v4.model.ListInstanceResp;
import com.lark.oapi.service.approval.v4.model.P1LeaveApprovalV4;
import com.lark.oapi.service.approval.v4.model.P1OutApprovalV4;
import com.lark.oapi.service.approval.v4.model.P1RemedyApprovalV4;
import com.lark.oapi.service.approval.v4.model.P1ShiftApprovalV4;
import com.lark.oapi.service.approval.v4.model.P1TripApprovalV4;
import com.lark.oapi.service.approval.v4.model.P1WorkApprovalV4;
import com.lark.oapi.service.approval.v4.model.P2ApprovalUpdatedV4;
import com.lark.oapi.service.approval.v4.model.PreviewInstanceReq;
import com.lark.oapi.service.approval.v4.model.PreviewInstanceResp;
import com.lark.oapi.service.approval.v4.model.QueryInstanceReq;
import com.lark.oapi.service.approval.v4.model.QueryInstanceResp;
import com.lark.oapi.service.approval.v4.model.QueryTaskReq;
import com.lark.oapi.service.approval.v4.model.QueryTaskResp;
import com.lark.oapi.service.approval.v4.model.RejectTaskReq;
import com.lark.oapi.service.approval.v4.model.RejectTaskResp;
import com.lark.oapi.service.approval.v4.model.RemoveInstanceCommentReq;
import com.lark.oapi.service.approval.v4.model.RemoveInstanceCommentResp;
import com.lark.oapi.service.approval.v4.model.ResubmitTaskReq;
import com.lark.oapi.service.approval.v4.model.ResubmitTaskResp;
import com.lark.oapi.service.approval.v4.model.SearchCcInstanceReq;
import com.lark.oapi.service.approval.v4.model.SearchCcInstanceResp;
import com.lark.oapi.service.approval.v4.model.SearchTaskReq;
import com.lark.oapi.service.approval.v4.model.SearchTaskResp;
import com.lark.oapi.service.approval.v4.model.SpecifiedRollbackInstanceReq;
import com.lark.oapi.service.approval.v4.model.SpecifiedRollbackInstanceResp;
import com.lark.oapi.service.approval.v4.model.SubscribeApprovalReq;
import com.lark.oapi.service.approval.v4.model.SubscribeApprovalResp;
import com.lark.oapi.service.approval.v4.model.TransferTaskReq;
import com.lark.oapi.service.approval.v4.model.TransferTaskResp;
import com.lark.oapi.service.approval.v4.model.UnsubscribeApprovalReq;
import com.lark.oapi.service.approval.v4.model.UnsubscribeApprovalResp;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApprovalService {
    private static final Logger log = LoggerFactory.getLogger(ApprovalService.class);
    private final Approval approval;
    private final ExternalApproval externalApproval;
    private final ExternalInstance externalInstance;
    private final ExternalTask externalTask;
    private final Instance instance;
    private final InstanceComment instanceComment;
    private final Task task;

    public ApprovalService(Config config) {
        this.approval = new Approval(config);
        this.externalApproval = new ExternalApproval(config);
        this.externalInstance = new ExternalInstance(config);
        this.externalTask = new ExternalTask(config);
        this.instance = new Instance(config);
        this.instanceComment = new InstanceComment(config);
        this.task = new Task(config);
    }

    public Approval approval() {
        return this.approval;
    }

    public ExternalApproval externalApproval() {
        return this.externalApproval;
    }

    public ExternalInstance externalInstance() {
        return this.externalInstance;
    }

    public ExternalTask externalTask() {
        return this.externalTask;
    }

    public Instance instance() {
        return this.instance;
    }

    public InstanceComment instanceComment() {
        return this.instanceComment;
    }

    public Task task() {
        return this.task;
    }

    public static abstract class P1OutApprovalV4Handler
    implements IEventHandler<P1OutApprovalV4> {
        @Override
        public P1OutApprovalV4 getEvent() {
            return new P1OutApprovalV4();
        }
    }

    public static abstract class P1TripApprovalV4Handler
    implements IEventHandler<P1TripApprovalV4> {
        @Override
        public P1TripApprovalV4 getEvent() {
            return new P1TripApprovalV4();
        }
    }

    public static abstract class P1RemedyApprovalV4Handler
    implements IEventHandler<P1RemedyApprovalV4> {
        @Override
        public P1RemedyApprovalV4 getEvent() {
            return new P1RemedyApprovalV4();
        }
    }

    public static abstract class P1ShiftApprovalV4Handler
    implements IEventHandler<P1ShiftApprovalV4> {
        @Override
        public P1ShiftApprovalV4 getEvent() {
            return new P1ShiftApprovalV4();
        }
    }

    public static abstract class P1WorkApprovalV4Handler
    implements IEventHandler<P1WorkApprovalV4> {
        @Override
        public P1WorkApprovalV4 getEvent() {
            return new P1WorkApprovalV4();
        }
    }

    public static abstract class P1LeaveApprovalV4Handler
    implements IEventHandler<P1LeaveApprovalV4> {
        @Override
        public P1LeaveApprovalV4 getEvent() {
            return new P1LeaveApprovalV4();
        }
    }

    public static abstract class P2ApprovalUpdatedV4Handler
    implements IEventHandler<P2ApprovalUpdatedV4> {
        @Override
        public P2ApprovalUpdatedV4 getEvent() {
            return new P2ApprovalUpdatedV4();
        }
    }

    public static class Task {
        private final Config config;

        public Task(Config config) {
            this.config = config;
        }

        public ApproveTaskResp approve(ApproveTaskReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ApproveTaskResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/tasks/approve", Sets.newHashSet(AccessTokenType.Tenant), req), ApproveTaskResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/tasks/approve", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ApproveTaskResp approve(ApproveTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/tasks/approve", Sets.newHashSet(AccessTokenType.Tenant), req);
            ApproveTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ApproveTaskResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/tasks/approve", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public QueryTaskResp query(QueryTaskReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            QueryTaskResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/approval/v4/tasks/query", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req), QueryTaskResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/tasks/query", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public QueryTaskResp query(QueryTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/approval/v4/tasks/query", Sets.newHashSet(AccessTokenType.Tenant, AccessTokenType.User), req);
            QueryTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, QueryTaskResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/tasks/query", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public RejectTaskResp reject(RejectTaskReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            RejectTaskResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/tasks/reject", Sets.newHashSet(AccessTokenType.Tenant), req), RejectTaskResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/tasks/reject", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public RejectTaskResp reject(RejectTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/tasks/reject", Sets.newHashSet(AccessTokenType.Tenant), req);
            RejectTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, RejectTaskResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/tasks/reject", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ResubmitTaskResp resubmit(ResubmitTaskReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ResubmitTaskResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/tasks/resubmit", Sets.newHashSet(AccessTokenType.Tenant), req), ResubmitTaskResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/tasks/resubmit", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ResubmitTaskResp resubmit(ResubmitTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/tasks/resubmit", Sets.newHashSet(AccessTokenType.Tenant), req);
            ResubmitTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ResubmitTaskResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/tasks/resubmit", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SearchTaskResp search(SearchTaskReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            SearchTaskResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/tasks/search", Sets.newHashSet(AccessTokenType.Tenant), req), SearchTaskResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/tasks/search", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SearchTaskResp search(SearchTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/tasks/search", Sets.newHashSet(AccessTokenType.Tenant), req);
            SearchTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SearchTaskResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/tasks/search", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public TransferTaskResp transfer(TransferTaskReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            TransferTaskResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/tasks/transfer", Sets.newHashSet(AccessTokenType.Tenant), req), TransferTaskResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/tasks/transfer", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public TransferTaskResp transfer(TransferTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/tasks/transfer", Sets.newHashSet(AccessTokenType.Tenant), req);
            TransferTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, TransferTaskResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/tasks/transfer", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class InstanceComment {
        private final Config config;

        public InstanceComment(Config config) {
            this.config = config;
        }

        public CreateInstanceCommentResp create(CreateInstanceCommentReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateInstanceCommentResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/:instance_id/comments", Sets.newHashSet(AccessTokenType.Tenant), req), CreateInstanceCommentResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/:instance_id/comments", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateInstanceCommentResp create(CreateInstanceCommentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/:instance_id/comments", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateInstanceCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateInstanceCommentResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/:instance_id/comments", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteInstanceCommentResp delete(DeleteInstanceCommentReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            DeleteInstanceCommentResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/approval/v4/instances/:instance_id/comments/:comment_id", Sets.newHashSet(AccessTokenType.Tenant), req), DeleteInstanceCommentResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/:instance_id/comments/:comment_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public DeleteInstanceCommentResp delete(DeleteInstanceCommentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "DELETE", "/open-apis/approval/v4/instances/:instance_id/comments/:comment_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            DeleteInstanceCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, DeleteInstanceCommentResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/:instance_id/comments/:comment_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListInstanceCommentResp list(ListInstanceCommentReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListInstanceCommentResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/approval/v4/instances/:instance_id/comments", Sets.newHashSet(AccessTokenType.Tenant), req), ListInstanceCommentResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/:instance_id/comments", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListInstanceCommentResp list(ListInstanceCommentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/approval/v4/instances/:instance_id/comments", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListInstanceCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListInstanceCommentResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/:instance_id/comments", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public RemoveInstanceCommentResp remove(RemoveInstanceCommentReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            RemoveInstanceCommentResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/:instance_id/comments/remove", Sets.newHashSet(AccessTokenType.Tenant), req), RemoveInstanceCommentResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/:instance_id/comments/remove", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public RemoveInstanceCommentResp remove(RemoveInstanceCommentReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/:instance_id/comments/remove", Sets.newHashSet(AccessTokenType.Tenant), req);
            RemoveInstanceCommentResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, RemoveInstanceCommentResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/:instance_id/comments/remove", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Instance {
        private final Config config;

        public Instance(Config config) {
            this.config = config;
        }

        public AddSignInstanceResp addSign(AddSignInstanceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            AddSignInstanceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/add_sign", Sets.newHashSet(AccessTokenType.Tenant), req), AddSignInstanceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/add_sign", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public AddSignInstanceResp addSign(AddSignInstanceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/add_sign", Sets.newHashSet(AccessTokenType.Tenant), req);
            AddSignInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, AddSignInstanceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/add_sign", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CancelInstanceResp cancel(CancelInstanceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CancelInstanceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/cancel", Sets.newHashSet(AccessTokenType.Tenant), req), CancelInstanceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/cancel", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CancelInstanceResp cancel(CancelInstanceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/cancel", Sets.newHashSet(AccessTokenType.Tenant), req);
            CancelInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CancelInstanceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/cancel", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CcInstanceResp cc(CcInstanceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CcInstanceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/cc", Sets.newHashSet(AccessTokenType.Tenant), req), CcInstanceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/cc", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CcInstanceResp cc(CcInstanceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/cc", Sets.newHashSet(AccessTokenType.Tenant), req);
            CcInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CcInstanceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/cc", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateInstanceResp create(CreateInstanceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateInstanceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances", Sets.newHashSet(AccessTokenType.Tenant), req), CreateInstanceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateInstanceResp create(CreateInstanceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateInstanceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetInstanceResp get(GetInstanceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetInstanceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/approval/v4/instances/:instance_id", Sets.newHashSet(AccessTokenType.Tenant), req), GetInstanceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/:instance_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetInstanceResp get(GetInstanceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/approval/v4/instances/:instance_id", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetInstanceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/:instance_id", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListInstanceResp list(ListInstanceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListInstanceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/approval/v4/instances", Sets.newHashSet(AccessTokenType.Tenant), req), ListInstanceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListInstanceResp list(ListInstanceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/approval/v4/instances", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListInstanceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PreviewInstanceResp preview(PreviewInstanceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            PreviewInstanceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/preview", Sets.newHashSet(AccessTokenType.Tenant), req), PreviewInstanceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/preview", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public PreviewInstanceResp preview(PreviewInstanceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/preview", Sets.newHashSet(AccessTokenType.Tenant), req);
            PreviewInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, PreviewInstanceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/preview", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public QueryInstanceResp query(QueryInstanceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            QueryInstanceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/query", Sets.newHashSet(AccessTokenType.Tenant), req), QueryInstanceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/query", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public QueryInstanceResp query(QueryInstanceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/query", Sets.newHashSet(AccessTokenType.Tenant), req);
            QueryInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, QueryInstanceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/query", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SearchCcInstanceResp searchCc(SearchCcInstanceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            SearchCcInstanceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/search_cc", Sets.newHashSet(AccessTokenType.Tenant), req), SearchCcInstanceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/search_cc", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SearchCcInstanceResp searchCc(SearchCcInstanceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/search_cc", Sets.newHashSet(AccessTokenType.Tenant), req);
            SearchCcInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SearchCcInstanceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/search_cc", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SpecifiedRollbackInstanceResp specifiedRollback(SpecifiedRollbackInstanceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            SpecifiedRollbackInstanceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/specified_rollback", Sets.newHashSet(AccessTokenType.Tenant), req), SpecifiedRollbackInstanceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/specified_rollback", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SpecifiedRollbackInstanceResp specifiedRollback(SpecifiedRollbackInstanceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/instances/specified_rollback", Sets.newHashSet(AccessTokenType.Tenant), req);
            SpecifiedRollbackInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SpecifiedRollbackInstanceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/instances/specified_rollback", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class ExternalTask {
        private final Config config;

        public ExternalTask(Config config) {
            this.config = config;
        }

        public ListExternalTaskResp list(ListExternalTaskReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            ListExternalTaskResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/approval/v4/external_tasks", Sets.newHashSet(AccessTokenType.Tenant), req), ListExternalTaskResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/external_tasks", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public ListExternalTaskResp list(ListExternalTaskReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/approval/v4/external_tasks", Sets.newHashSet(AccessTokenType.Tenant), req);
            ListExternalTaskResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, ListExternalTaskResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/external_tasks", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class ExternalInstance {
        private final Config config;

        public ExternalInstance(Config config) {
            this.config = config;
        }

        public CheckExternalInstanceResp check(CheckExternalInstanceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CheckExternalInstanceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/external_instances/check", Sets.newHashSet(AccessTokenType.Tenant), req), CheckExternalInstanceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/external_instances/check", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CheckExternalInstanceResp check(CheckExternalInstanceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/external_instances/check", Sets.newHashSet(AccessTokenType.Tenant), req);
            CheckExternalInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CheckExternalInstanceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/external_instances/check", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateExternalInstanceResp create(CreateExternalInstanceReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateExternalInstanceResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/external_instances", Sets.newHashSet(AccessTokenType.Tenant), req), CreateExternalInstanceResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/external_instances", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateExternalInstanceResp create(CreateExternalInstanceReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/external_instances", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateExternalInstanceResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateExternalInstanceResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/external_instances", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class ExternalApproval {
        private final Config config;

        public ExternalApproval(Config config) {
            this.config = config;
        }

        public CreateExternalApprovalResp create(CreateExternalApprovalReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateExternalApprovalResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/external_approvals", Sets.newHashSet(AccessTokenType.Tenant), req), CreateExternalApprovalResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/external_approvals", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateExternalApprovalResp create(CreateExternalApprovalReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/external_approvals", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateExternalApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateExternalApprovalResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/external_approvals", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetExternalApprovalResp get(GetExternalApprovalReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetExternalApprovalResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/approval/v4/external_approvals/:approval_code", Sets.newHashSet(AccessTokenType.Tenant), req), GetExternalApprovalResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/external_approvals/:approval_code", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetExternalApprovalResp get(GetExternalApprovalReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/approval/v4/external_approvals/:approval_code", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetExternalApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetExternalApprovalResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/external_approvals/:approval_code", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }

    public static class Approval {
        private final Config config;

        public Approval(Config config) {
            this.config = config;
        }

        public CreateApprovalResp create(CreateApprovalReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            CreateApprovalResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/approvals", Sets.newHashSet(AccessTokenType.Tenant), req), CreateApprovalResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/approvals", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public CreateApprovalResp create(CreateApprovalReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/approvals", Sets.newHashSet(AccessTokenType.Tenant), req);
            CreateApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, CreateApprovalResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/approvals", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetApprovalResp get(GetApprovalReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            GetApprovalResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/approval/v4/approvals/:approval_code", Sets.newHashSet(AccessTokenType.Tenant), req), GetApprovalResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/approvals/:approval_code", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public GetApprovalResp get(GetApprovalReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "GET", "/open-apis/approval/v4/approvals/:approval_code", Sets.newHashSet(AccessTokenType.Tenant), req);
            GetApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, GetApprovalResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/approvals/:approval_code", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SubscribeApprovalResp subscribe(SubscribeApprovalReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            SubscribeApprovalResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/approvals/:approval_code/subscribe", Sets.newHashSet(AccessTokenType.Tenant), req), SubscribeApprovalResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/approvals/:approval_code/subscribe", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public SubscribeApprovalResp subscribe(SubscribeApprovalReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/approvals/:approval_code/subscribe", Sets.newHashSet(AccessTokenType.Tenant), req);
            SubscribeApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, SubscribeApprovalResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/approvals/:approval_code/subscribe", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UnsubscribeApprovalResp unsubscribe(UnsubscribeApprovalReq req, RequestOptions reqOptions) throws Exception {
            RawResponse httpResponse;
            UnsubscribeApprovalResp resp;
            if (reqOptions == null) {
                reqOptions = new RequestOptions();
            }
            if ((resp = UnmarshalRespUtil.unmarshalResp(httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/approvals/:approval_code/unsubscribe", Sets.newHashSet(AccessTokenType.Tenant), req), UnsubscribeApprovalResp.class)) == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/approvals/:approval_code/unsubscribe", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }

        public UnsubscribeApprovalResp unsubscribe(UnsubscribeApprovalReq req) throws Exception {
            RequestOptions reqOptions = new RequestOptions();
            RawResponse httpResponse = Transport.send(this.config, reqOptions, "POST", "/open-apis/approval/v4/approvals/:approval_code/unsubscribe", Sets.newHashSet(AccessTokenType.Tenant), req);
            UnsubscribeApprovalResp resp = UnmarshalRespUtil.unmarshalResp(httpResponse, UnsubscribeApprovalResp.class);
            if (resp == null) {
                log.error(String.format("%s,callError,req=%s,respHeader=%s,respStatusCode=%s,respBody=%s,", "/open-apis/approval/v4/approvals/:approval_code/unsubscribe", Jsons.DEFAULT.toJson((Object)req), Jsons.DEFAULT.toJson(httpResponse.getHeaders()), httpResponse.getStatusCode(), new String(httpResponse.getBody(), StandardCharsets.UTF_8)));
                throw new IllegalArgumentException("The result returned by the server is illegal");
            }
            resp.setRawResponse(httpResponse);
            resp.setRequest(req);
            return resp;
        }
    }
}

