/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config.connector.http;

import java.util.Arrays;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.http.HttpRetryConfig;
import org.apache.eventmesh.common.config.connector.http.HttpWebhookConfig;

public class SinkConnectorConfig {
    private String connectorName;
    private String[] urls;
    private boolean keepAlive = true;
    private int keepAliveTimeout = 60000;
    private int connectionTimeout = 5000;
    private int idleTimeout = 5000;
    private int maxConnectionPoolSize = 50;
    private HttpRetryConfig retryConfig = new HttpRetryConfig();
    private HttpWebhookConfig webhookConfig = new HttpWebhookConfig();
    private String deliveryStrategy = "ROUND_ROBIN";
    private boolean skipDeliverException = false;
    private boolean isParallelized = true;
    private int parallelism = 2;

    public static void populateFieldsWithDefaults(SinkConnectorConfig config) {
        int commonHttpIdleTimeout = 5000;
        int webhookHttpIdleTimeout = 15000;
        if (config.getIdleTimeout() == 0) {
            int idleTimeout = config.webhookConfig.isActivate() ? 15000 : 5000;
            config.setIdleTimeout(idleTimeout);
        }
    }

    @Generated
    public SinkConnectorConfig() {
    }

    @Generated
    public String getConnectorName() {
        return this.connectorName;
    }

    @Generated
    public String[] getUrls() {
        return this.urls;
    }

    @Generated
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Generated
    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    @Generated
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Generated
    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    @Generated
    public int getMaxConnectionPoolSize() {
        return this.maxConnectionPoolSize;
    }

    @Generated
    public HttpRetryConfig getRetryConfig() {
        return this.retryConfig;
    }

    @Generated
    public HttpWebhookConfig getWebhookConfig() {
        return this.webhookConfig;
    }

    @Generated
    public String getDeliveryStrategy() {
        return this.deliveryStrategy;
    }

    @Generated
    public boolean isSkipDeliverException() {
        return this.skipDeliverException;
    }

    @Generated
    public boolean isParallelized() {
        return this.isParallelized;
    }

    @Generated
    public int getParallelism() {
        return this.parallelism;
    }

    @Generated
    public void setConnectorName(String connectorName) {
        this.connectorName = connectorName;
    }

    @Generated
    public void setUrls(String[] urls) {
        this.urls = urls;
    }

    @Generated
    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Generated
    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    @Generated
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Generated
    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @Generated
    public void setMaxConnectionPoolSize(int maxConnectionPoolSize) {
        this.maxConnectionPoolSize = maxConnectionPoolSize;
    }

    @Generated
    public void setRetryConfig(HttpRetryConfig retryConfig) {
        this.retryConfig = retryConfig;
    }

    @Generated
    public void setWebhookConfig(HttpWebhookConfig webhookConfig) {
        this.webhookConfig = webhookConfig;
    }

    @Generated
    public void setDeliveryStrategy(String deliveryStrategy) {
        this.deliveryStrategy = deliveryStrategy;
    }

    @Generated
    public void setSkipDeliverException(boolean skipDeliverException) {
        this.skipDeliverException = skipDeliverException;
    }

    @Generated
    public void setParallelized(boolean isParallelized) {
        this.isParallelized = isParallelized;
    }

    @Generated
    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinkConnectorConfig)) {
            return false;
        }
        SinkConnectorConfig other = (SinkConnectorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isKeepAlive() != other.isKeepAlive()) {
            return false;
        }
        if (this.getKeepAliveTimeout() != other.getKeepAliveTimeout()) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.getIdleTimeout() != other.getIdleTimeout()) {
            return false;
        }
        if (this.getMaxConnectionPoolSize() != other.getMaxConnectionPoolSize()) {
            return false;
        }
        if (this.isSkipDeliverException() != other.isSkipDeliverException()) {
            return false;
        }
        if (this.isParallelized() != other.isParallelized()) {
            return false;
        }
        if (this.getParallelism() != other.getParallelism()) {
            return false;
        }
        String this$connectorName = this.getConnectorName();
        String other$connectorName = other.getConnectorName();
        if (this$connectorName == null ? other$connectorName != null : !this$connectorName.equals(other$connectorName)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUrls(), other.getUrls())) {
            return false;
        }
        HttpRetryConfig this$retryConfig = this.getRetryConfig();
        HttpRetryConfig other$retryConfig = other.getRetryConfig();
        if (this$retryConfig == null ? other$retryConfig != null : !((Object)this$retryConfig).equals(other$retryConfig)) {
            return false;
        }
        HttpWebhookConfig this$webhookConfig = this.getWebhookConfig();
        HttpWebhookConfig other$webhookConfig = other.getWebhookConfig();
        if (this$webhookConfig == null ? other$webhookConfig != null : !((Object)this$webhookConfig).equals(other$webhookConfig)) {
            return false;
        }
        String this$deliveryStrategy = this.getDeliveryStrategy();
        String other$deliveryStrategy = other.getDeliveryStrategy();
        return !(this$deliveryStrategy == null ? other$deliveryStrategy != null : !this$deliveryStrategy.equals(other$deliveryStrategy));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SinkConnectorConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isKeepAlive() ? 79 : 97);
        result = result * 59 + this.getKeepAliveTimeout();
        result = result * 59 + this.getConnectionTimeout();
        result = result * 59 + this.getIdleTimeout();
        result = result * 59 + this.getMaxConnectionPoolSize();
        result = result * 59 + (this.isSkipDeliverException() ? 79 : 97);
        result = result * 59 + (this.isParallelized() ? 79 : 97);
        result = result * 59 + this.getParallelism();
        String $connectorName = this.getConnectorName();
        result = result * 59 + ($connectorName == null ? 43 : $connectorName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getUrls());
        HttpRetryConfig $retryConfig = this.getRetryConfig();
        result = result * 59 + ($retryConfig == null ? 43 : ((Object)$retryConfig).hashCode());
        HttpWebhookConfig $webhookConfig = this.getWebhookConfig();
        result = result * 59 + ($webhookConfig == null ? 43 : ((Object)$webhookConfig).hashCode());
        String $deliveryStrategy = this.getDeliveryStrategy();
        result = result * 59 + ($deliveryStrategy == null ? 43 : $deliveryStrategy.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SinkConnectorConfig(connectorName=" + this.getConnectorName() + ", urls=" + Arrays.deepToString(this.getUrls()) + ", keepAlive=" + this.isKeepAlive() + ", keepAliveTimeout=" + this.getKeepAliveTimeout() + ", connectionTimeout=" + this.getConnectionTimeout() + ", idleTimeout=" + this.getIdleTimeout() + ", maxConnectionPoolSize=" + this.getMaxConnectionPoolSize() + ", retryConfig=" + this.getRetryConfig() + ", webhookConfig=" + this.getWebhookConfig() + ", deliveryStrategy=" + this.getDeliveryStrategy() + ", skipDeliverException=" + this.isSkipDeliverException() + ", isParallelized=" + this.isParallelized() + ", parallelism=" + this.getParallelism() + ")";
    }
}

