/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.accounting.closure.domain.GLClosure;
import org.apache.fineract.accounting.common.AccountingConstants;
import org.apache.fineract.accounting.journalentry.data.ChargePaymentDTO;
import org.apache.fineract.accounting.journalentry.data.SharesDTO;
import org.apache.fineract.accounting.journalentry.data.SharesTransactionDTO;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorForShares;
import org.apache.fineract.accounting.journalentry.service.AccountingProcessorHelper;
import org.apache.fineract.organisation.office.domain.Office;
import org.springframework.stereotype.Component;

@Component
public class CashBasedAccountingProcessorForShares
implements AccountingProcessorForShares {
    private final AccountingProcessorHelper helper;

    public void createJournalEntriesForShares(SharesDTO sharesDTO) {
        GLClosure latestGLClosure = this.helper.getLatestClosureByBranch(sharesDTO.getOfficeId().longValue());
        Long shareAccountId = sharesDTO.getShareAccountId();
        Long shareProductId = sharesDTO.getShareProductId();
        String currencyCode = sharesDTO.getCurrencyCode();
        for (SharesTransactionDTO transactionDTO : sharesDTO.getNewTransactions()) {
            LocalDate transactionDate = transactionDTO.getTransactionDate();
            String transactionId = transactionDTO.getTransactionId();
            Office office = this.helper.getOfficeById(transactionDTO.getOfficeId().longValue());
            Long paymentTypeId = transactionDTO.getPaymentTypeId();
            BigDecimal amount = transactionDTO.getAmount();
            BigDecimal chargeAmount = transactionDTO.getChargeAmount();
            List feePayments = transactionDTO.getFeePayments();
            this.helper.checkForBranchClosures(latestGLClosure, transactionDate);
            if (transactionDTO.getTransactionType().isPurchased()) {
                this.createJournalEntriesForPurchase(shareAccountId, shareProductId, currencyCode, transactionDTO, transactionDate, transactionId, office, paymentTypeId, amount, chargeAmount, feePayments);
                continue;
            }
            if (transactionDTO.getTransactionType().isRedeemed() && transactionDTO.getTransactionStatus().isApproved()) {
                this.createJournalEntriesForRedeem(shareAccountId, shareProductId, currencyCode, transactionDate, transactionId, office, paymentTypeId, amount, chargeAmount, feePayments);
                continue;
            }
            if (!transactionDTO.getTransactionType().isChargePayment()) continue;
            this.helper.createCashBasedJournalEntriesForSharesCharges(office, currencyCode, AccountingConstants.CashAccountsForShares.SHARES_REFERENCE, AccountingConstants.CashAccountsForShares.INCOME_FROM_FEES, shareProductId, paymentTypeId, shareAccountId, transactionId, transactionDate, amount, feePayments);
        }
    }

    public void createJournalEntriesForRedeem(Long shareAccountId, Long shareProductId, String currencyCode, LocalDate transactionDate, String transactionId, Office office, Long paymentTypeId, BigDecimal amount, BigDecimal chargeAmount, List<ChargePaymentDTO> feePayments) {
        if (chargeAmount == null || chargeAmount.compareTo(BigDecimal.ZERO) <= 0) {
            this.helper.createJournalEntriesForShares(office, currencyCode, AccountingConstants.CashAccountsForShares.SHARES_EQUITY.getValue().intValue(), AccountingConstants.CashAccountsForShares.SHARES_REFERENCE.getValue().intValue(), shareProductId, paymentTypeId, shareAccountId, transactionId, transactionDate, amount);
        } else {
            this.helper.createDebitJournalEntryForShares(office, currencyCode, AccountingConstants.CashAccountsForShares.SHARES_EQUITY.getValue().intValue(), shareProductId, paymentTypeId, shareAccountId, transactionId, transactionDate, amount.add(chargeAmount));
            this.helper.createCreditJournalEntryForShares(office, currencyCode, AccountingConstants.CashAccountsForShares.SHARES_REFERENCE.getValue().intValue(), shareProductId, paymentTypeId, shareAccountId, transactionId, transactionDate, amount);
            this.helper.createCashBasedJournalEntryForSharesCharges(office, currencyCode, AccountingConstants.CashAccountsForShares.INCOME_FROM_FEES, shareProductId, shareAccountId, transactionId, transactionDate, chargeAmount, feePayments);
        }
    }

    public void createJournalEntriesForPurchase(Long shareAccountId, Long shareProductId, String currencyCode, SharesTransactionDTO transactionDTO, LocalDate transactionDate, String transactionId, Office office, Long paymentTypeId, BigDecimal amount, BigDecimal chargeAmount, List<ChargePaymentDTO> feePayments) {
        if (transactionDTO.getTransactionStatus().isApplied()) {
            if (chargeAmount == null || chargeAmount.compareTo(BigDecimal.ZERO) <= 0) {
                this.helper.createJournalEntriesForShares(office, currencyCode, AccountingConstants.CashAccountsForShares.SHARES_REFERENCE.getValue().intValue(), AccountingConstants.CashAccountsForShares.SHARES_SUSPENSE.getValue().intValue(), shareProductId, paymentTypeId, shareAccountId, transactionId, transactionDate, amount);
            } else {
                this.helper.createDebitJournalEntryForShares(office, currencyCode, AccountingConstants.CashAccountsForShares.SHARES_REFERENCE.getValue().intValue(), shareProductId, paymentTypeId, shareAccountId, transactionId, transactionDate, amount);
                this.helper.createCreditJournalEntryForShares(office, currencyCode, AccountingConstants.CashAccountsForShares.SHARES_SUSPENSE.getValue().intValue(), shareProductId, paymentTypeId, shareAccountId, transactionId, transactionDate, amount.subtract(chargeAmount));
                this.helper.createCashBasedJournalEntryForSharesCharges(office, currencyCode, AccountingConstants.CashAccountsForShares.INCOME_FROM_FEES, shareProductId, shareAccountId, transactionId, transactionDate, chargeAmount, feePayments);
            }
        } else if (transactionDTO.getTransactionStatus().isApproved()) {
            BigDecimal amountForJE = amount;
            if (chargeAmount != null && chargeAmount.compareTo(BigDecimal.ZERO) > 0) {
                amountForJE = amount.subtract(chargeAmount);
            }
            this.helper.createJournalEntriesForShares(office, currencyCode, AccountingConstants.CashAccountsForShares.SHARES_SUSPENSE.getValue().intValue(), AccountingConstants.CashAccountsForShares.SHARES_EQUITY.getValue().intValue(), shareProductId, paymentTypeId, shareAccountId, transactionId, transactionDate, amountForJE);
        } else if (transactionDTO.getTransactionStatus().isRejected()) {
            if (chargeAmount != null && chargeAmount.compareTo(BigDecimal.ZERO) > 0) {
                this.helper.revertCashBasedJournalEntryForSharesCharges(office, currencyCode, AccountingConstants.CashAccountsForShares.INCOME_FROM_FEES, shareProductId, shareAccountId, transactionId, transactionDate, chargeAmount, feePayments);
                this.helper.createDebitJournalEntryForShares(office, currencyCode, AccountingConstants.CashAccountsForShares.SHARES_SUSPENSE.getValue().intValue(), shareProductId, paymentTypeId, shareAccountId, transactionId, transactionDate, amount.subtract(chargeAmount));
                this.helper.createCreditJournalEntryForShares(office, currencyCode, AccountingConstants.CashAccountsForShares.SHARES_REFERENCE.getValue().intValue(), shareProductId, paymentTypeId, shareAccountId, transactionId, transactionDate, amount);
            } else {
                this.helper.createJournalEntriesForShares(office, currencyCode, AccountingConstants.CashAccountsForShares.SHARES_SUSPENSE.getValue().intValue(), AccountingConstants.CashAccountsForShares.SHARES_REFERENCE.getValue().intValue(), shareProductId, paymentTypeId, shareAccountId, transactionId, transactionDate, amount);
            }
        }
    }

    @Generated
    public CashBasedAccountingProcessorForShares(AccountingProcessorHelper helper) {
        this.helper = helper;
    }
}

