/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.batch.command.internal;

import com.google.common.base.Splitter;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.batch.command.CommandStrategy;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.batch.domain.BatchResponse;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.portfolio.interestpauses.api.LoanInterestPauseApiResource;
import org.apache.fineract.portfolio.interestpauses.data.InterestPauseRequestDto;
import org.springframework.stereotype.Component;

@Component
public class UpdateLoanInterestPauseByExternalIdCommandStrategy
implements CommandStrategy {
    private final LoanInterestPauseApiResource loanInterestPauseApiResource;
    private final DefaultToApiJsonSerializer<CommandProcessingResult> toApiJsonSerializer;

    public BatchResponse execute(BatchRequest request, UriInfo uriInfo) {
        BatchResponse response = new BatchResponse();
        response.setRequestId(request.getRequestId());
        response.setHeaders(request.getHeaders());
        List pathParameters = Splitter.on((char)'/').splitToList((CharSequence)CommandStrategyUtils.relativeUrlWithoutVersion((BatchRequest)request));
        String loanExternalId = (String)pathParameters.get(2);
        Long variationId = Long.parseLong((String)pathParameters.get(4));
        InterestPauseRequestDto interestPauseRequestDto = InterestPauseRequestDto.fromJson((String)request.getBody());
        CommandProcessingResult commandProcessingResult = this.loanInterestPauseApiResource.updateInterestPauseByExternalId(loanExternalId, variationId, interestPauseRequestDto);
        response.setStatusCode(Integer.valueOf(200));
        response.setBody(this.toApiJsonSerializer.serialize((Object)commandProcessingResult));
        return response;
    }

    @Generated
    public UpdateLoanInterestPauseByExternalIdCommandStrategy(LoanInterestPauseApiResource loanInterestPauseApiResource, DefaultToApiJsonSerializer<CommandProcessingResult> toApiJsonSerializer) {
        this.loanInterestPauseApiResource = loanInterestPauseApiResource;
        this.toApiJsonSerializer = toApiJsonSerializer;
    }
}

