/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.cob.loan.LoanCOBBusinessStep;
import org.apache.fineract.infrastructure.configuration.domain.ConfigurationDomainService;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.repayment.LoanRepaymentOverdueBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.loanaccount.domain.LoanStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CheckLoanRepaymentOverdueBusinessStep
implements LoanCOBBusinessStep {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckLoanRepaymentOverdueBusinessStep.class);
    private final ConfigurationDomainService configurationDomainService;
    private final BusinessEventNotifierService businessEventNotifierService;

    public Loan execute(Loan loan) {
        List<LoanStatus> nonDisbursedStatuses = Arrays.asList(LoanStatus.INVALID, LoanStatus.SUBMITTED_AND_PENDING_APPROVAL, LoanStatus.APPROVED);
        if (!nonDisbursedStatuses.contains(loan.getStatus()) && loan.getSummary().getTotalOutstanding().compareTo(BigDecimal.ZERO) > 0) {
            log.debug("start processing loan repayment overdue business step for loan with Id [{}]", (Object)loan.getId());
            Long numberOfDaysAfterDueDateToRaiseEvent = this.configurationDomainService.retrieveRepaymentOverdueDays();
            if (loan.getLoanProduct().getOverDueDaysForRepaymentEvent() != null && loan.getLoanProduct().getOverDueDaysForRepaymentEvent() > 0) {
                numberOfDaysAfterDueDateToRaiseEvent = loan.getLoanProduct().getOverDueDaysForRepaymentEvent().longValue();
            }
            LocalDate currentDate = DateUtils.getBusinessLocalDate();
            List loanRepaymentScheduleInstallments = loan.getRepaymentScheduleInstallments();
            for (LoanRepaymentScheduleInstallment repaymentSchedule : loanRepaymentScheduleInstallments) {
                LocalDate installmentDueDate;
                if (repaymentSchedule.isObligationsMet() || !CheckLoanRepaymentOverdueBusinessStep.isOverDueEventNeededToBeSent((Loan)loan, (Long)numberOfDaysAfterDueDateToRaiseEvent, (LocalDate)currentDate, (LoanRepaymentScheduleInstallment)repaymentSchedule, (LocalDate)(installmentDueDate = repaymentSchedule.getDueDate()))) continue;
                this.businessEventNotifierService.notifyPostBusinessEvent((BusinessEvent)new LoanRepaymentOverdueBusinessEvent(repaymentSchedule));
                break;
            }
            log.debug("end processing loan repayment overdue business step for loan with Id [{}]", (Object)loan.getId());
        }
        return loan;
    }

    public String getEnumStyledName() {
        return "CHECK_LOAN_REPAYMENT_OVERDUE";
    }

    public String getHumanReadableName() {
        return "Check loan repayment overdue";
    }

    private static boolean isOverDueEventNeededToBeSent(Loan loan, Long numberOfDaysBeforeDueDateToRaiseEvent, LocalDate currentDate, LoanRepaymentScheduleInstallment repaymentScheduleInstallment, LocalDate repaymentDate) {
        return repaymentDate.plusDays(numberOfDaysBeforeDueDateToRaiseEvent).equals(currentDate) && repaymentScheduleInstallment.getTotalOutstanding(loan.getCurrency()).isGreaterThanZero();
    }

    @Generated
    public CheckLoanRepaymentOverdueBusinessStep(ConfigurationDomainService configurationDomainService, BusinessEventNotifierService businessEventNotifierService) {
        this.configurationDomainService = configurationDomainService;
        this.businessEventNotifierService = businessEventNotifierService;
    }
}

